<?php
			// (c) Copyright Mark McIlroy 2020

	include "library.php";

	$cxn = start_code();
	
	
//    $end_date = date_create( date( "Y-m-d" ) );

//    $start_date = date_create( $current_year."-".$current_month."-01" );


	$start_date = val( $_POST, "start_date" );

	$end_date = val( $_POST, "end_date" );
  
         
	$start_date = date_create( convert_date_to_yyyymmdd( $start_date, "dd/mm/yyyy", $cxn ) );

	$end_date = date_create( convert_date_to_yyyymmdd( $end_date, "dd/mm/yyyy", $cxn ) );


	$current_day = date( "d", $end_date->format( "U" ) );
	$current_month = date( "m", $end_date->format( "U" ) );
	$current_year = date( "Y", $end_date->format( "U" ) );

    
    page_header( "Monthly P & L", $cxn );


	$current_day = date( "d", $end_date->format( "U" ) );

    $days_this_month = $current_day;
    

    echo "<table>";
    
	echo "<tr><td valign='top'>&nbsp;&nbsp;<b>".black( "Month" )."</b></td>";

	echo "<td style='padding-right: 45px'>&nbsp;</td>";

	echo "<td valign='top'>&nbsp;&nbsp;<b>".black( "Income" )."</b></td>";
	echo "<td valign='top'>&nbsp;&nbsp;<b>".black( "Expenses" )."</b></td>";
	echo "<td valign='top'>&nbsp;&nbsp;<b>".black( "Net" )."</b></td>";

	echo "<td style='padding-right: 45px'>&nbsp;</td>";
	
	echo "<td valign='top'>&nbsp;&nbsp;<b>".black( "ACV Revenue" )."</b></td>";
	echo "<td valign='top'>&nbsp;&nbsp;<b>".black( "ACV Expenses" )."</b></td>";
	echo "<td valign='top'>&nbsp;&nbsp;<b>".black( "ACV Net" )."</b></td>";

	echo "<td style='padding-right: 45px'>&nbsp;</td>";

	echo "<td valign='top'>&nbsp;&nbsp;<b>".black( "Total Net" )."</b></td>";
				
	echo "</tr>";


	$this_end_date = clone $end_date;
	
    $this_start_date = date_create( $current_year."-".$current_month."-01" );

	
    for ($i=0; $this_start_date->format( "Y-m-d" ) >= $start_date->format( "Y-m-d" ); $i++)
    {
        display_month( $days_this_month, $this_start_date->format( "M Y" ), $this_start_date->format( "Y-m-d" ), $this_end_date->format( "Y-m-d" ), $cxn );

		$this_end_date = clone $this_start_date;

    	date_sub( $this_end_date, date_interval_create_from_date_string( '1 day' ));

    	date_sub( $this_start_date, date_interval_create_from_date_string( '1 month' ));
		 
        $last_day_of_month = $this_end_date->format( "d" );

    	$days_this_month = $last_day_of_month;
    }

 
    function display_month( $days_this_month, $month_text, $report_start_date, $report_end_date, $cxn )
    {
        $income = get_transaction_total( "Income", $report_start_date, $report_end_date, $cxn );

        $expenses = get_transaction_total( "Expense", $report_start_date, $report_end_date, $cxn );
		        
				
		$query = "SELECT SUM(transaction.net_amount) as revenue FROM aitkencv_accounts.transaction INNER JOIN aitkencv_accounts.accounts ON accounts.code = transaction.account WHERE accounts.type = 'Revenue' and effective_date >= '".$report_start_date."' AND effective_date <= '".$report_end_date."'";	
	    	
    	$result = run_query( $query, $cxn );
    
		$data = get_row( $result );
	
		$acv_revenue = $data['revenue'];


		$query = "SELECT SUM(transaction.net_amount) as expenses FROM aitkencv_accounts.transaction INNER JOIN aitkencv_accounts.accounts ON accounts.code = transaction.account WHERE accounts.type = 'Expense' and effective_date >= '".$report_start_date."' AND effective_date <= '".$report_end_date."'";	
	    	
    	$result = run_query( $query, $cxn );
    
		$data = get_row( $result );
	
		$acv_expenses = $data['expenses'];
					
				
        $this_date_dt = date_create( $report_start_date );

        $this_date_str = $this_date_dt->format( "Y-m-d" );

        $total_expense_allocation = 0;
    
		$day = 0;
		$account_balance_total = 0;

		echo "<tr><td>&nbsp;&nbsp;".black( $month_text )."</td>";
		
		echo "<td></td>";
		
		echo "<td>&nbsp;&nbsp;".black( number_format( $income, 0 ) )."</td>";
		
		echo "<td>&nbsp;&nbsp;".black( number_format( $expenses, 0 ) )."</td>";

		echo "<td align='right'>&nbsp;&nbsp;".sign_format( $income - $expenses, number_format( $income - $expenses, 0 ) )."</td>";

		echo "<td></td>";
		
		echo "<td align='right'>&nbsp;&nbsp;".black( number_format( $acv_revenue, 0 ) )."</td>";

		echo "<td align='right'>&nbsp;&nbsp;".black( number_format( $acv_expenses, 0 ) )."</td>";

		echo "<td align='right'>&nbsp;&nbsp;".sign_format( $acv_revenue - $acv_expenses, number_format( $acv_revenue - $acv_expenses, 0 ) )."</td>";

		echo "<td></td>";

		echo "<td align='right'>&nbsp;&nbsp;".sign_format( ($income - $expenses) + ($acv_revenue - $acv_expenses), number_format( ($income - $expenses) + ($acv_revenue - $acv_expenses), 0 ) )."</td>";
						
		echo "</tr>";
	}


	echo "</table>";

	echo "<br><br><br>";
	
	echo show_home_link( $cxn );

	echo "<br><br><br>";

?>