<?php
			// (c) Copyright Mark McIlroy 2020

	include "library.php";

	$cxn = start_code( true );

    process_external_entry_point( $cxn );

	$userid = val( $_SESSION, 'userid' );

	$logged_in = val( $_SESSION, 'logged_in' );

        // Notes
        
        // Retail stock is held as a current asset at its retail sale value
        
        // COGS is accumulated as the wholesale cost of items, accumulated when the item is actually sold
        

	$date_today = date( "Y-m-d" );

	acv_login( "/", "/scripts/", $cxn );


	$_SESSION['session_active'] = "yes";

	page_header( "", $cxn );


	$this_date = date_create( date("Y-m-d") );

    $effective_date = $this_date->format( "Y-m-d" );

    echo "<table width='100%' style='border-collapse: collapse;'>";
    
    if (! low_res_screen( $cxn ))
	    echo "<tr><td width='65%'>&nbsp;</td><td width='35%'>";
	else
        echo "<tr><td width='15%'>&nbsp;</td><td width='85%'>";

    echo "<table>";  	

    $total = process_one_timeframe( $effective_date, true, true, false, false, true, $cxn );

	echo "<tr><td>&nbsp;</td></tr>";

    echo "</td></tr></table>";
	
	echo "<table>";
	
	$_1_week_forward = date_create( date( "Y-m-d") );

   	date_add( $_1_week_forward, date_interval_create_from_date_string( '10 days' ));
	
	$_1_week_forward_txt = $_1_week_forward->format( "Y-m-d" );


	$_3_weeks_forward = date_create( date( "Y-m-d") );

   	date_add( $_3_weeks_forward, date_interval_create_from_date_string( '3 weeks' ));
	
	$_3_weeks_forward_txt = $_3_weeks_forward->format( "Y-m-d" );


	$query = "SELECT due_date, amount, notes, accounts.type FROM upcoming_items INNER JOIN accounts ON upcoming_items.account = accounts.code WHERE due_date <= '".$_3_weeks_forward_txt."' ";
	
	$query .= "UNION ALL SELECT effective_date as due_date, transaction_amount as amount, accounts.display_name as notes, accounts.type FROM pending_transactions INNER JOIN accounts ON pending_transactions.account = accounts.code WHERE effective_date <= '".$_1_week_forward_txt."' ";
	
	$query .= "UNION ALL SELECT next_due as due_date, amount, description, accounts.type FROM regular_transactions INNER JOIN accounts ON regular_transactions.account = accounts.code WHERE next_due <= '".$_1_week_forward_txt."' ORDER BY due_date";
	
	$result = run_query( $query, $cxn );

    for ($i=0; $i < query_num_rows( $result ); $i++)
    {
    	$data = get_row( $result );

		
		$this_date = date_create( $data['due_date'] );

    	$day_of_week = date( "l", $this_date->format( "U" ) );


		if ($data['type'] == 'Income')
		{
			echo "<tr><td style='padding-left: 15px'>";

			echo green( convert_date_str_yyyymmdd_to_ddmmyyyy( $data['due_date'] ) );

			echo "</td><td style='padding-left: 15px'>";

			echo green( $day_of_week );
	
			echo "</td><td align='right' style='padding-left: 15px'>";

			echo green( '$'.number_format( $data['amount'], 2 ) );

			echo "</td><td style='padding-left: 15px'>";

			echo green( val( $data, 'notes' ) );
		}
		else
		{
			echo "<tr><td style='padding-left: 15px'>";

			echo black( convert_date_str_yyyymmdd_to_ddmmyyyy( $data['due_date'] ) );

			echo "</td><td style='padding-left: 15px'>";
						
			echo black( $day_of_week );
	
			echo "</td><td align='right' style='padding-left: 15px'>";
				
			echo black( '$'.number_format( $data['amount'], 2 ) );
		
			echo "</td><td style='padding-left: 15px'>";

			echo black( val( $data, 'notes' ) );
		}
		
		echo "</td></tr>";
	}


    echo "</table>";

    echo "</table>";
	
    echo "<br>";

    if (! low_res_screen( $cxn ))	
	    echo "<br><br>";

    show_home_page_menu( $cxn );



    echo "<br>";
    echo "<br>";
    echo "<br>";
    echo "<br>";
    echo "<br>";
    echo "<br>";
    echo "<br>";
    echo "<br>";
    echo "<br>";
    echo "<br>";

?>