<?php

    define( "database_name", "academi1_pacificsoln" );
	define( "common_data_database_name", "academi1_commondata" );
	define( "pathroot", "/home/academi1/public_html/pacificsoln" );
	define( "forms_library", "/home/academi1/public_html/common_code/forms_library.php" );
	define( "error_log_filename", "/home/academi1/public_html/pacificsoln/error_log.txt" );
	define( "sitename", "Pacific Solutions Australia" );
	define( "sitecode", "PACIFIC_SOLUTIONS_AUSTRALIA" );
	
	

	include "/home/academi1/public_html/common_code/common_library.php";


	function start_code( $first=false, $db="" )
	{
        if (session_status() != PHP_SESSION_ACTIVE)
    		session_start();


			/* set config options */

		ini_set( "error_log", error_log_filename );

		ini_set( "display_errors", "on" );
		ini_set( "display_startup_errors", "on" );

		ini_set( "date.timezone", "Australia/Melbourne" );
		
		$cxn = db_login( database_name );

        log_hits( val( $_GET, "source" ), $cxn );

        return ($cxn);		
	}
		
		
		

		/* generate the heading line for a page */

		/* NOTE: don't call this before any jump_to_page's or the jumps wont work */

	function page_header( $page_title, $cxn )
	{
	    echo "<!doctype html>";

	    if (use_amp && low_res_screen())
	    {
	        echo "<html amp lang='en'>";
	        echo "<script async src='https://cdn.ampproject.org/v0.js'></script>";
	        echo "<link rel='canonical' href='.".$_SERVER['PHP_SELF']."'>";
	    }
        else
    		echo "<head>";

		echo "<meta charset='utf-8'>";
		echo "<meta name='viewport' content='width=device-width, minimum-scale=1, initial-scale=1.0'>";

	    if (use_amp && low_res_screen())
	    {
            echo "<script async custom-element='amp-carousel' src='https://cdn.ampproject.org/v0/amp-carousel-0.1.js'></script>";
            echo "<style amp-boilerplate>body{-webkit-animation:-amp-start 8s steps(1,end) 0s 1 normal both;-moz-animation:-amp-start 8s steps(1,end) 0s 1 normal both;-ms-animation:-amp-start 8s steps(1,end) 0s 1 normal both;animation:-amp-start 8s steps(1,end) 0s 1 normal both}@-webkit-keyframes -amp-start{from{visibility:hidden}to{visibility:visible}}@-moz-keyframes -amp-start{from{visibility:hidden}to{visibility:visible}}@-ms-keyframes -amp-start{from{visibility:hidden}to{visibility:visible}}@-o-keyframes -amp-start{from{visibility:hidden}to{visibility:visible}}@keyframes -amp-start{from{visibility:hidden}to{visibility:visible}}</style><noscript><style amp-boilerplate>body{-webkit-animation:none;-moz-animation:none;-ms-animation:none;animation:none}</style></noscript>";
	    }

    
//		echo "<html><head><meta name='viewport' content='width=device-width, initial-scale=1.0'>";

        echo "<meta name='keywords' content='IT,Systems,Solutions,Online,Web,Development'>";

        echo "<meta name='description' content='Pacific Solutions Australia develops on-line web-based IT systems for all purposes. We are available to develop systems for clients in Australia or internationally.'>";

//		echo "<meta http-equiv='Content-Type' content='text/html; charset=UTF-8'>";

//	    echo "<span style='font-size: 11pt; font-family: verdana;'>This business is not currently operating.<br><br><br>";
	    
//	    exit();
	    

	    if (! use_amp)
	    {
            if (val( $_SESSION, "screen_width" ) == "")
                write_screen_parameters_function();
	    }


            // Google Analytics 
            
	    if (! use_amp)
	    {
            echo "<!-- Global site tag (gtag.js) - Google Analytics -->";
            echo "<script async src='https://www.googletagmanager.com/gtag/js?id=UA-97849346-4'></script>";
            echo "<script>";
            echo "  window.dataLayer = window.dataLayer || [];";
            echo "  function gtag(){dataLayer.push(arguments);}";
            echo "  gtag('js', new Date());";
            echo "  gtag('config', 'UA-97849346-4');";
            echo "</script>";
	    }
	    

			// use the old version of the Google Analytics libary until Google Translate supports the new library

//		include "google_analytics_legacy_version.php";

//		include "google_analytics_tracking.php";


		echo '<link rel="icon" type="image/png" sizes="192x192"  href="/images/android-icon-192x192.png">';
		echo '<link rel="icon" type="image/png" sizes="32x32" href="/favicon-32x32.png">';
		echo '<link rel="icon" type="image/png" sizes="96x96" href="/favicon-96x96.png">';
		echo '<link rel="icon" type="image/png" sizes="16x16" href="/favicon-16x16.png">';


        $source = val( $_SESSION, "source" );

	    log_hits( $source, $cxn );

		log_page_view( $cxn );


			// define styles 

        if (use_amp)
        	echo "<style amp-custom>";
        else
        	echo "<style>";

		echo "html, body {";
		
		echo "margin:0;";
		echo "padding:0;";
		echo "}";

		define_styles();

		write_common_styles();
		
		echo "</style>";


		echo "<title>".$page_title."</title></head>";
		
		
	    if (! use_amp)
	    {
        	if (val( $_SESSION, "screen_width" ) == "")
        	{
//                echo "<body onload='js_set_screen_parameters();'>";
                
          	    echo "<script>";
          	    
                echo "  var request = new XMLHttpRequest();";

                echo "  request.open( 'GET', '/set_screen_parameters.php?sw='+screen.width+'&sh='+screen.height, false );";      // `false` makes the request synchronous

                echo "  request.send( null );";
          	    
                echo "  location.reload();";
                
                echo "</script>";
                
                exit();
	        }  
            else
        		echo "<body>";
	    }
	    else
    		echo "<body>";

	}


		/* define the CSS styles */

	function define_styles()
	{
//		echo "<style amp-custom>";


			// the following style creates the scrollbar format.
			
		echo    ".main_text_window {";				
		echo    "    scrollbar-face-color: #000000;";
		echo    "    scrollbar-shadow-color: #FFFFFF;";
		echo    "    scrollbar-highlight-color: #FFFFFF;";
		echo    "    scrollbar-3dlight-color: #FFFFFF;";
		echo    "    scrollbar-darkshadow-color: #FFFFFF;";
		echo    "    scrollbar-track-color: #FFFFFF;";
		echo    "    scrollbar-arrow-color: #FFFFFF;";
		echo    " opacity: 0.88;";
		echo    "}";
		echo    "";
		
		echo    ".main_text_window::-webkit-scrollbar {";
		echo    "    width: 12px;";
		echo    "}";
		echo    " ";
		
		echo    ".main_text_window::-webkit-scrollbar-track {";
		echo    "    -webkit-box-shadow: inset 0 0 6px rgba(0,0,0,0.3); ";
		echo    "}";
		echo    " ";
		
		echo    ".main_text_window::-webkit-scrollbar-thumb {";		// Chrome
		echo    "    background: rgba(0,0,20,0.1); ";
		echo    "    -webkit-box-shadow: inset 0 0 6px rgba(0,0,0,0.5); ";
		echo    "}";

		
//		echo ".body   		{ color: #000000; font-family: verdana; font-size: 10pt}";



		$top_section_color = "#0000a0";

        
		$top_section_color_mobile = "#000000";


		if (! low_res_screen())
		{
            echo ".home_page_heading {line-height: 40px; font-family: Calibri; font-size: 22pt; color: #007500; border-top: 2px solid #ffffff;}";

       		echo ".pageheading      { color: #000000; font-family: verdana; font-weight: bold; font-style: italic; font-size: 11pt}";

   			echo ".generaltext	{ color: #000000; font-family: verdana; font-size: 10.5pt}";

   			echo ".fprompt      { color: #000000; font-family: verdana; font-size: 10.5pt}";

			echo ".gred	{ color: #af0000; font-family: verdana; font-size: 11pt}";

			echo ".ggreen { color: #00af00; font-family: verdana; font-size: 11pt}";

			echo ".glink { color: #0000bb; font-family: verdana; font-size: 11pt}";

			echo ".gemail { color: #000000; font-family: courier; font-size: 12pt; text-decoration: none}";

            echo ".attribution_link {font-family: verdana; font-size: 8pt; color: #000000;}";
            
            echo ".pricing_table_text { color: #000000; font-family: verdana; font-size: 10pt; }";

            echo ".phone_number {color: #0000bb; text-decoration: none; }";

            echo ".home_page_link {color: #0000bb; font-family: verdana; font-size: 9pt}";
            echo ".home_page_link:hover {color: #8B4513; font-family: verdana; font-size: 9pt}";
            
            
// 000098
		    echo ".menulink      	{color: #000000; border-style: none; padding-left: 0; padding-right: 0; font-size: 13pt; font-family: Calibri; text-decoration:none}";
		    echo ".menulink:hover	{color: #008500; cursor: pointer; border-style: none; padding-left: 0; padding-right: 0; font-size: 13pt; font-family: Calibri; text-decoration:none}";			    
//		    echo ".menulink:hover	{color: #000000; cursor: pointer; border-style: none; padding-left: 0; padding-right: 0; background-color: #eeeeee; font-size: 13pt; font-family: Calibri; text-decoration:none}";			    
		}
		else
		{
            echo ".home_page_heading {padding-top: 3; padding-bottom: 3; font-family: Calibri; font-size: 14pt; line-height: 18pt; color: #ffffff; opacity: 0.9; background-color: #007500;}";
		    echo ".pageheading  { color: #000000; font-family: arial; font-weight: bold; font-style: italic; font-size: 11pt}";

			echo ".generaltext	{ color: #000000; font-family: verdana; font-size: 11pt}";

   			echo ".fprompt      { color: #0000bb; font-family: verdana; font-size: 11pt}";

			echo ".gred	{ color: #af0000; font-family: verdana; font-size: 11pt}";

			echo ".ggreen { color: #00af00; font-family: verdana; font-size: 11pt}";

			echo ".gemail { color: #000000; font-family: courier; font-size: 12pt; text-decoration: none}";

			echo ".glink { color: #0000bb; font-family: verdana; font-size: 13pt}";

			echo ".menulink         { text-decoration: none; color: ".$top_section_color_mobile."; font-family: verdana; font-size: 9.5pt; line-height: 18px;}";
			echo ".menulink:visited { text-decoration: none; color: ".$top_section_color_mobile."; font-family: verdana; font-size: 9.5pt; line-height: 18px;}";
			echo ".menulink:link  { text-decoration: none; color: ".$top_section_color_mobile."; font-family: verdana; font-size: 9.5pt; line-height: 18px;}";
			echo ".menulink:hover { text-decoration: none; color: ".$top_section_color_mobile."; font-family: verdana; font-size: 9.5pt; line-height: 18px;}";

            echo ".attribution_link {font-family: verdana; font-size: 8pt; color: #000000;}";
            
            echo ".pricing_table_text { color: #000000; font-family: verdana; font-size: 10pt; }";

            echo ".home_page_link {color: #0000bb; font-family: verdana; font-size: 9pt}";
            echo ".home_page_link:hover {color: #007500; font-family: verdana; font-size: 9pt}";
            
            echo ".phone_number {color: #0000bb; text-decoration: none; }";
		}

        echo ".border_collapse { border-collapse: collapse; }";

		echo ".greenbuttondesktop {cursor: pointer; border: 1px solid #008000; border-radius: 5px; background: #008000; color: #ffffff; font-family: arial; font-size: ".$fs2."px; ";
		echo "    border-width:1px; padding-left:1px; padding-right:2px; padding-top:1px; display: inline-block; padding-bottom:1px; margin:1px; ";
		echo "    }";
		

		echo ".greenbuttondesktop:hover {cursor: pointer; border: 1px solid #006b00; border-radius: 5px; background: #006b00; color: #ffffff; font-family: arial; font-size: ".$fs2."px; ";
		echo "    border-width:1px; padding-left:1px; padding-right:2px; padding-top:1px; display: inline-block; padding-bottom:1px; margin:1px; ";
		echo "    }";

    	echo ".greenbuttonmobile {cursor: pointer; line-height: 12pt; border:solid #008000; border-radius: 4px; background: #008000; color: #ffffff; font-family: arial; font-size: ".$fsm."px; ";
		echo "    border-width:1px; padding-left:1px; padding-right:1px; padding-top:1px; display: inline-block; padding-bottom:1px; margin:1px; ";
		echo "    }";

		echo ".greenbuttonmobile:hover {cursor: pointer; line-height: 12pt; border:solid #006b00; border-radius: 4px; background: #006b00; color: #ffffff; font-family: arial; font-size: ".$fsm."px; ";
		echo "    border-width:1px; padding-left:1px; padding-right:1px; padding-top:1px; display: inline-block; padding-bottom:1px; margin:1px; ";
		echo "    }";

//		echo "</style>";
    }



    function write_page_text( $this_page )
    {
    	if (! low_res_screen())	
    	{
            $top_section_background = "#ffffff";

            $contact_details_style = "line-height: 16px; font-family: Calibri; font-size: 11.5pt; color: #000000; background-color: ".$top_section_background;

  		    echo "<table style='border-collapse: collapse;'><tr><td style='background-color: #007500; line-height: 40px; font-family: verdana; font-size: 18pt; color: #FFFFFF;'>&nbsp;&nbsp;&nbsp;Pacific Solutions Australia&nbsp;&nbsp;&nbsp;</td></tr></table>";
// 		    echo "<table width='100%' style='border-collapse: collapse;'><tr><td width='2%' style='border-top: 2px solid #ffffff; border-left: 2px solid #ffffff; '>&nbsp;</td><td width='98%' valign='top' style='line-height: 40px; font-family: Arial; font-size: 18.5pt; color: #004499; border-top: 2px solid #ffffff;'>Pacific Solutions Australia</span>";
  		    
//            echo "</td><td width='2%' style='background: #8B4513; border-top: 2px solid #ffffff; '>&nbsp;</td><td width='80%'>&nbsp;</td></tr><tr><td style='line-height: 4px;'>&nbsp;</td>";
//            echo "</td><td width='80%'>&nbsp;</td></tr><tr><td style='line-height: 2px;'>&nbsp;</td><td style='line-height: 2px; background: #007500;'>&nbsp;";
            
            echo "</td></tr></table>";
            
            echo "<br>";
            
            echo "</td><td></td></tr></table>";


//    		echo "<table width='100%' class='border_collapse;'><tr><td width='100%' style='line-height: 14px;'>&nbsp;</td></tr></table>";


            echo "<table width='100%' style='border-collapse: collapse;'><tr><td width='2%'>&nbsp;</td><td width='15%' valign='top'><table>";

//            if (use_amp && low_res_screen())
//        		echo "<tr><td>&nbsp;&nbsp;<amp-img src='/images/Logo_67_wide.png' alt='MPL logo' height='38' width='67'></amp-img></td></tr>";				
//            else            
//        		echo "<tr><td>&nbsp;&nbsp;<img src='/images/Logo_67_wide.png' alt='MPL logo' height='38' width='67'></td></tr>";				
        }
    	else
    	{
    		echo "<table cellspacing='0' width='100%'><tr><td class='home_page_heading' align='left'>&nbsp;&nbsp;Pacific Solutions Australia</td></tr></table>";
    
    		echo "<br>";
    		
    		echo "<table width='100%'><tr><td width='30%' align='center'>";
    		
    		
//          if (use_amp && low_res_screen())
//    		    echo "<amp-img src='images/Logo_67_wide.png' alt='MPL logo' height='38' width='67'></amp-img></td>";				
//            else    		
//    		    echo "<img src='images/Logo_67_wide.png' alt='MPL logo' height='38' width='67></td>";				

    		echo "<td align='center'></td><td width='70%'></td></tr></table>";		
    
    //		echo "<br>";		
    
    		echo "<table width='100%'><tr><td width='3%'></td>";
    
    		echo "<td width='30%' valign='top' class='menulink'>";		
    	}
    

    	write_primary_menu( $this_page );
    
    
    	if (! low_res_screen())	
    	{
    	    echo "</table><td>";

    		echo "<td valign='top' align='center' style='opacity: 0.95; min-width: 350px;'>";
        
            echo "<br>";
    
            if (use_amp && low_res_screen())
            	echo "<amp-img alt='Page image 8' src='/images/pixabay_melbourne-panorama-614036_1920_3' width='280'></amp-img>";		
//            	echo "<amp-img alt='Page image 8' src='/images/pexels-photo-380768_280_wide.jpg' width='280'></amp-img>";		
            else
           	    echo "<img alt='Page image 8' src='/images/Melbourne_skyline2.jpg' width='300'>";		
//           	    echo "<img alt='Page image 8' src='/images/pixabay_melbourne-panorama-614036_1920_3.jpg' width='300'>";		

        
//        if ($this_page == "main_text.php")
//       	    echo "<img alt='Page image 8' src='/images/pexels-photo-380768.jpeg' width='280'>";		
//        else
//        if ($this_page == "pricing_text.php")
//        	echo "<img alt='Page image 1' src='images/freestock_2878987_money.jpg' width='280'>";
//        else
//        if ($this_page == "service_offering_text.php")
//        	echo "<img alt='Page image 2' src='images/freestock_135132563_coffee.jpg' width='280'>";
//        else
//        if ($this_page == "forms_text.php")
//        	echo "<img alt='Page image 3' src='images/freestock_2665171_paper_forms.jpg' width='280'>";		
//        else
//        if ($this_page == "legal_text.php")
//        	echo "<img alt='Page image 4' src='images/freestock_1995094_law.jpg' width='280'>";		
//        else
//        if ($this_page == "news_text.php")
//        	echo "<img alt='Page image 5' src='images/freestock_145899_news.jpg' width='280'>";		
//        else
//        if ($this_page == "articles_text.php")
//        	echo "<img alt='Page image 6' src='images/freestock_39959371_books.jpg' width='280'>";		
////        else
////        if ($this_page == "contact_us_text.php")
////        	echo "<img alt='Page image 9' src='images/freestock_396739330_business_office.jpg' width='280'>";		


////        if ($this_page == "contact_us_text.php")
////        	echo "<img alt='Page image 5' src='images/mark_professional2_low_res_cropped.jpg' width='165'>";		
////        else


    		echo "</td>";
    
    		echo "<td width='2%'></td>";
    
    		echo "<td width='60%' align='left' valign='top'>";				
    		
    	    echo "<br>";
    
    		echo "<div id='div1' class='main_text_window' id='div1'>";
        	
    //    	else
    //    		echo "<div id='div1' class='main_text_window' style='opacity: 0.78; max-height: 500px; overflow: auto; border:10px solid #454545; margin-left: 10px; background-color: #454545; 'id='div1'>";				
    
    
    //		echo "<div id='div1' class='main_text_window' style='margin-left: 10px; background-color: #eeeeee; opacity: 0.9;' id='div1'>";
    	    
    //		echo "<div id='div1' class='main_text_window' style='max-height: 500px; overflow: auto; margin-left: 10px;' id='div1'>";
    	}
    	else
    		echo "</td><td width='2%'></td><td width='65%' align='left' valign='top'></tr></table><table width='100%'><td width='3%'>&nbsp;</td><td width='94%'>";
    
    
    		// this is the main text that appears in the main window as selected by the menu
    		
    	include $this_page; 

    	if (low_res_screen())		
    	    echo "</td><td width='3%'>&nbsp;</td></tr></table>";
    

//    	if ($this_page != "main_text.php")
//    	    echo "<br><br><a href='/' class='glink' style='font-size: 9pt; color: #000000'>Home</a>";
  
    
    	if (! low_res_screen())		
    		echo "</div>";
    
    
    	if (! low_res_screen())
    		echo "</td><td width='26%'>&nbsp;</td></tr></table>";		
    	else
    		echo "</td><td width='5%'>&nbsp;</td></tr></table>";
    		
    		
    	echo "<br><br><br><br>";
    	
    	echo "</body>";
    	
    	echo "</html>";
    }

		
		
		// write the primary menu
		
	function write_primary_menu( $this_page )
	{
		menu_option( "System&nbsp;Development", "/", $this_page, "main_text.php" );

//		if (! low_res_screen())
//    		menu_option( "Service&nbsp;Offering", "/service_offering.php" );
//    	else
//    		menu_option( "Service Offering", "/service_offering.php" );

//		menu_option( "Pricing", "/pricing.php" );

//		menu_option( "Forms", "/forms.php" );

//		menu_option( "Legal", "/legal.php" );

//		menu_option( "Books", "/books.php" );

		menu_option( "News", "/news.php", $this_page, "news_text.php" );

		menu_option( "Fees", "/fees.php", $this_page, "fees_text.php" );

		menu_option( "About Us", "/about_us.php", $this_page, "about_us_text.php" );
			
		menu_option( "Contact Us", "/contact_us.php", $this_page, "contact_us_text.php" );

//		menu_option( "Links", "links.php", true );

//    	if (! low_res_screen())
//    		menu_option( "IT&nbsp;Systems<br>&nbsp;&nbsp;Development", "it_systems_development.php" );
//    	else
//	    	menu_option( "IT Systems Development", "it_systems_development.php" );

//		menu_option( "Articles", "articles.php" );
    }


		// write one menu option
		
	function menu_option( $prompt, $filename, $this_page, $menu_option_page )
	{
        $background_color = "#eeeeee";
        
        $small_link = false;

		if (! low_res_screen())
		{
		    if ($small_link)
            	echo "<tr><td height='38pt' width='120px' align='left' class='menulink' onclick='location=\"/".$filename."\"' style='margin-left: 10px; font-size: 12pt'>&nbsp;&nbsp;&nbsp;".$prompt."&nbsp;&nbsp;&nbsp;</a></td></tr>";
            else
            	echo "<tr><td height='38pt' width='120px' align='left' style='margin-left: 10px'><a class='menulink' href='".$filename."'>&nbsp;&nbsp;".$prompt."</a></td></tr>";
//            	echo "<tr><td height='38pt' width='120px' align='left' onclick='location=\"".$filename."\"' class='menulink' style='margin-left: 10px'>&nbsp;&nbsp;&nbsp;".$prompt."&nbsp;&nbsp;&nbsp;</td></tr>";

		}
		else
		{
		    if ($this_page == $menu_option_page)
		        $background_color = "#002280";
		    else
		        $background_color = "#1144b8";

			echo "<div style='line-height: 48px; width: 280px; background-color: ".$background_color."; border-radius: 10px; color: #ffffff; font-size: 14pt; font-family: verdana; text-decoration: none;' onclick=\"window.location.href='".$filename."'\">&nbsp;&nbsp;&nbsp;".$prompt."</div><br>";
		}
	}
	

        
    function log_page_view( $cxn )
    {
        $ip_country = get_ip_country( $cxn );
        
        $today_date = date( "Y-m-d" );
        
	    $device = device_type();
        
        
        $query = "SELECT id FROM page_views WHERE page_view_date = '".$today_date."' AND ip_country = '".$ip_country."' AND device = '".$device."'";
        
        
            // on rare occasions there may be two records created for one date if two users are checking and adding at the same time.
            
        if (query_has_rows( $query, $cxn ))
        {
            $query = "UPDATE page_views SET count = count + 1 WHERE page_view_date = '".$today_date."' AND ip_country = '".$ip_country."' AND device = '".$device."'";
            
            $result = run_query( $query, $cxn );
        }
        else
        {
            $query = "INSERT INTO page_views (page_view_date, ip_country, count, device) VALUES ('".$today_date."', '".$ip_country."', 1, '".$device."' )";
            
            $result = run_query( $query, $cxn );            
        }
    }
	
	function db_login( $database )
	{
		$host = "localhost";
		$user = "academi1_mlm1";
		$password = "plastic1";

        $cxn = new mysqli( $host, $user, $password, $database );

		if ($cxn->connect_errno)
		{
			echo "<br><span style='font-size: 14pt; font-family: verdana'>".sitename." is currently unavailable.<br><br>Please try again in half an hour.<br><br></span>";
			
			echo "Error text: ".$cxn->connect_error."<br>";

			exit();
		}

		return $cxn;
	}
	
	
?>