<?php

	define( "sitename", "Melbourne Paraplanning" );
	define( "sitecode", "MELBOURNE_PARAPLANNING_WORKFLOW" );
	define( "business_name", "Melbourne Paraplanning" );

	define( "common_data_database_name", "academi1_commondata" );
	define( "from_email_address", "mark.mcilroy@indie-ventures.com" );
	define( "reply_email_address", "mark.mcilroy@indie-ventures.com" );
	define( "manager_email_address", "mark.mcilroy@indie-ventures.com" );
	define( "error_log_filename", "/home/academi1/public_html/melbourneparaplanning/workflow/error_log.txt" );


            // 80 is the hourly rate times the SOA production time
            
    define( "fee_calc_formula", "Math.round( ((80 * (4.43 + parseInt(NumberofStrategies.value)*0.501) * 1.043)    ) / 5) * 5;" );


            // 0.65 is the paraplanner commission
            
    define( "commission_calc_formula", "Math.round(parseFloat(soa_fee.value) * 0.65);" );



            // 0.65 * 0.2 is the checker commission
            
    define( "checker_commission_calc_formula", "Math.round(parseFloat(soa_fee.value) * 0.65 * 0.2);" );



//  the common library include requires:
//    1. edit  /opt/cpanel/ea-php70/root/etc/php.ini
//    2. set allow_url_fopen and allow_url_include to On

	include "/home/academi1/public_html/common_code/common_library.php";
	include "/home/academi1/public_html/common_code/forms_library.php";



		// functions in this custom library file
		//
		// page_header()
		// define_styles()
		// build_paraplanner_list()
		// build_practice_list()
		// build_adviser_list()
		


    			/* startup code to be called at the top of each file */

	function start_code( $first=false, $db="" )
	{
			/* set up paths */

		$domain = val( $_SERVER, "HTTP_HOST" );


//		chdir( "/home/academi1/m-m-ventures/melbpara/workflow" );
		
		
//		$domain_root = substr( $domain, 4, strlen( $domain ) - 4 );
//		$domain_root = substr( $domain_root, 0, strlen( $domain_root ) - 4 );

		session_start();

		$_SESSION['domain'] = $domain;

		$_SESSION['pathroot'] = "/home/academi1/public_html/melbourneparaplanning/workflow";


			/* set up variables */

		$database = "academi1_mpsworkflow";

        if ($db != "")
		    $database = $db;
		    
        $_SESSION['database'] = $database;
		    

		$user = val( $_GET, "user" );


			/* remember user across pages */

			/* set config options */

		ini_set( "error_log", $_SESSION['pathroot']."/error_log.txt" );

			// don't enable these options as they my expose technical details of the site to viewers
		ini_set( "display_errors", "on" );
		ini_set( "display_startup_errors", "on" );

        error_reporting( E_ALL & ~E_DEPRECATED );
        
		ini_set( "gc_maxlifetime", 1*60*60 );		/* set session timeout to 1 hour */

		ini_set( "date.timezone", "Australia/Melbourne" );
		
		if (! $first )
			check_url();

		$cxn = db_login( $database );

//                if ($cxn == 0)
//                    echo $domain."<br>";


		return ($cxn);
	}



		/* generate the heading line for a page */


		/* NOTE: don't call this before any jump_to_page's or the jumps wont work */

	function page_header( $heading, $cxn, $on_load="", $dont_jump=false, $home_page=false, $bg_color="" )
	{
    	echo "<style> html, body {";
    	echo "margin:0;";
    	echo "padding:0;";
    	echo "}";
    	echo "</style>";

        if (! low_res_screen())    
        	echo "<table cellpadding='0' cellspacing='0' width='100%'><tr><td style='line-height: 40px; font-family: Calibri; font-size: 18pt; color: #ffffff; background-color: #006000' align='left'>&nbsp;&nbsp;&nbsp;MPS Workflow System</td></tr></table>";
        else
        	echo "<table cellpadding='0' cellspacing='0' width='100%'><tr><td style='line-height: 30px; font-family: Calibri; font-size: 14pt; color: #ffffff; background-color: darkblue' align='left'>&nbsp;&nbsp;&nbsp;MPS Workflow System</td></tr></table>";

	    echo "<br>";

        if (low_res_screen())    
    	    echo "<br>";


        $_SESSION['sitename'] = 'MPS Workflow System';

		$_SESSION['session_active'] = "yes";
		
//		echo "<html><head><meta name='viewport' content='width=device-width, initial-scale=1.0'><meta http-equiv='expires' content='".date( "D, d M Y", time() - 60*60*24 )." 00:00:00 GMT'>";
		
		echo "<html><head><meta name='viewport' content='width=device-width, initial-scale=1.0'>";

		echo "<meta http-equiv='Content-Type' content='text/html; charset=UTF-8'>";

		echo '<link rel="shortcut icon" href="/favicon.ico" type="image/x-icon">';
		echo '<link rel="icon" href="/favicon.ico" type="image/x-icon">';

//		echo "<div>";		


			/* define styles */

		echo "<style>";


		write_common_styles();
		
		$data = define_styles( $home_page );


		echo "</style>";


		$bg = $data['bg'];
		$rose = $data['rose'];


				/* light blue background color for entire page */
				
//		$bg = "#cceeff";	
//		$bg = "#f0ffff";
		
//		$bg = "#f0fcff";
//		$bg = "#dbd1b4";	// sand

//		$bg = "#f8f8f8";	// gray


		if ($bg_color != "")
			$bg = $bg_color;

		if ($heading != "")
		{
			if ($on_load != "")
				echo "<title>".$_SESSION['sitename'].": ".$heading."</title></head><body bgcolor='".$bg."' onLoad=\"".$on_load."\">";
			else
				echo "<title>".$_SESSION['sitename'].": ".$heading."</title></head><body bgcolor='".$bg."'>";
		}
		else
		{
			if ($on_load != "")
				echo "<title>".$_SESSION['sitename']."</title></head><body bgcolor='".$bg."' onLoad=\"".$on_load."\">";
			else
				echo "<title>".$_SESSION['sitename']."</title></head><body bgcolor='".$bg."'>";
		}


		echo "<table width='100%'><tr><td width='2%'>&nbsp</td><td>";


		if ($heading != "")
		{
			echo "<table width='100%'><td width='30%'><span class='pgheading' valign='center'>".$heading."</span></td>";


			echo "<td width='10%' valign='center'></td>";
			echo "<td width='10%'></td>";

			echo "<td width='10%' valign='center'></td>";
			echo "<td width='10%'></td>";

			echo "<td width='5%'></td>";

			echo "<td width='20%' align = 'CENTER'>";

			show_green_button( "Home", 80, "index.php", "internaljump", "true" );
			
			echo "</td></table>";
				
			echo "<span style='font-size: 6pt'>&nbsp;<br></span>";
		}
		else
		{
//			echo "<table width='100%'><tr><td width='80%' align='left'></td>";

//			echo "</tr></table>";
		}
	}


		/* define the CSS styles */

	function define_styles( $home_page )
	{
		$color_scheme = val( $_SESSION, 'color_scheme' );

				/* standard */

//		if ($color_scheme == "" || $color_scheme == 0 || $color_scheme == 3)


		if ($home_page)
			$bg = '#ffffff';
//				$bg = '#ccffff';
		else
			$bg = '#ffffff';

		$rose = "images/rose.gif";
		
		echo "body   		{ color: #000000; verdana; font-size: ".fs( 12 )."pt}";

		echo "a:visited	{color: #0000bb; text-decoration: underline}";
		echo "a:link	{color: #0000bb; text-decoration: underline}";

		echo "a.menubaritem			{color: #000000; font-size:".fs( 12 )."pt; font-family:verdana; text-decoration:none}";
		echo "a.menubaritem:visited {color: #000000; font-size:".fs( 12 )."pt; font-family:verdana; text-decoration:none}";
		echo "a.menubaritem:link	{color: #000000; font-size:".fs( 12 )."pt; font-family:verdana; text-decoration:none}";
		echo "a.menubaritem:hover   {color: #000000; font-weight: bold; background-color: #eeeeee; font-size:".fs( 12 )."pt; font-family:verdana; text-decoration: none}";

		echo ".hl {cursor: pointer; color: #bb0000; background-color: #eeeeee; font-size:".fs( 12 )."pt; font-family:verdana; text-decoration: none}";
		echo ".uhl {color: #0000bb; font-size:".fs( 12 )."pt; font-family:verdana; text-decoration: none}";

		echo ".gblack         { color: #000000; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".gblue          { color: #0000bb; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".gred           { color: #bb0000; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".ggreen         { color: #00bb00; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".gwatermark     { color: #999999; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".gpink          { color: #FF69B4; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".gmidgreen      { color: #008000; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".gwhite         { color: #ffffff; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".ggrey          { color: #bbbbbb; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".gbrown         { color: #bf7d40; font-family: verdana; font-size: ".fs( 12 )."pt}";


		if (! low_res_screen())
        {				
			echo ".fprompt        { padding-left: 2px; margin-right: 3px; color: #0000bb; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".finput         { padding-left: 2px; margin-right: 3px; color: #000000; padding-left: 2px; border-style: solid; border-width: 1px; border-color: #cccccc; font-family: verdana; font-size: ".fs( 12 )."pt}";			
			echo ".fradio         { padding-left: 2px; margin-right: 3px; color: #000000; font-family: verdana; font-size: ".fs( 12 )."pt}";

			echo ".fprompt_error  { padding-left: 2px; color: #ff0000; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".finput_error   { padding-left: 2px; color: #000000; padding-left: 2px; border-style: solid; border-width: 1px; border-color: #cccccc; background-color: #ff9999; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".fradio_error   { padding-left: 2px; color: #000000; background-color: #ff9999; font-family: verdana; font-size: ".fs( 12 )."pt}";
        }
        else
        {
			echo ".fprompt        { color: #0000bb; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".finput         { color: #000000; padding-left: 2px; border-style: solid; border-width: 1px; border-color: #cccccc; font-family: verdana; font-size: ".fs( 12 )."pt}";			
			echo ".fradio         { color: #000000; font-family: verdana; font-size: ".fs( 12 )."pt}";

			echo ".fprompt_error  { color: #ff0000; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".finput_error   { color: #000000; padding-left: 2px; border-style: solid; border-width: 1px; border-color: #cccccc; background-color: #ff9999; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".fradio_error   { color: #000000; background-color: #ff9999; font-family: verdana; font-size: ".fs( 12 )."pt}";
        }

		echo ".dprompt        { padding-left: 2px; margin-right: 3px; color: #0000bb; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".dtext          { padding-left: 2px; margin-right: 3px; color: #000000; font-family: verdana; font-size: ".fs( 12 )."pt}";

		echo ".paraheading    { color: #0000bb; font-family: verdana; font-size: ".fs( 12 )."pt}";

		echo ".mainmenuheading    { color: #bb0000; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".mainmenuitem			{color: #0000bb; font-size: ".fs( 12 )."pt; font-family:verdana; text-decoration:none}";
		echo ".mainmenuitem:visited	{color: #0000bb; font-size: ".fs( 12 )."pt; font-family:verdana; text-decoration:none}";
		echo ".mainmenuitem:link	{color: #0000bb; font-size: ".fs( 12 )."pt; font-family:verdana; text-decoration:none}";
		echo ".mainmenuitem:hover	{cursor: pointer; color: #00b000; font-size: ".fs( 12 )."pt; font-family:verdana; text-decoration:none; background: #eeeeee;}";

	    echo ".menulink2      	{color: #000000; border-style: none; padding-left: 0; padding-right: 0; font-size: 13pt; font-family: Calibri; text-decoration:none}";
	    echo ".menulink2:link  	{color: #000000; border-style: none; padding-left: 0; padding-right: 0; font-size: 13pt; font-family: Calibri; text-decoration:none}";
	    echo ".menulink2:hover	{color: #bbbbbb; cursor: pointer; border-style: none; padding-left: 0; padding-right: 0; font-size: 13pt; font-family: Calibri; text-decoration:none}";			    

		echo ".pgheading      { color: #0000bb; font-family: verdana; font-size: ".fs( 16 )."pt}";
		echo ".homeheading    { color: #0000bb; font-family: times; font-size: ".fs( 26 )."pt}";

		echo ".glink		  { color: #0000bb; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".glink:visited  { color: #0000bb; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".glink:link     { color: #0000bb; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".glink:hover    { color: darkgreen; font-family: verdana; font-size: ".fs( 12 )."pt}";

		echo ".pinklink:visited { text-decoration: none; color: #FF69B4; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".pinklink:link  { text-decoration: none; color: #FF69B4; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".pinklink:hover { text-decoration: underline; color: #FF69B4; font-family: verdana; font-size: ".fs( 12 )."pt}";

		echo ".redlink:visited { text-decoration: none; color: #ff0000; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".redlink:link  { text-decoration: none; color: #ff0000; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".redlink:hover { text-decoration: underline; color: #ff0000; font-family: verdana; font-size: ".fs( 12 )."pt}";
		
		echo ".lpinklink:visited { text-decoration: none; color: #ffd7ff; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".lpinklink:link  { text-decoration: none; color: #ffd7ff; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".lpinklink:hover { text-decoration: underline; color: #ffd7ff; font-family: verdana; font-size: ".fs( 12 )."pt}";

		echo ".whitelink:visited { text-decoration: underline; color: #ffffff; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".whitelink:link  { text-decoration: underline; color: #ffffff; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".whitelink:hover { text-decoration: underline; color: #ffffff; font-family: verdana; font-size: ".fs( 12 )."pt}";

		echo ".bluelink:visited { text-decoration: underline; color: #0000bb; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".bluelink:link  { text-decoration: underline; color: #0000bb; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".bluelink:hover { text-decoration: underline; color: #0000bb; font-family: verdana; font-size: ".fs( 12 )."pt}";

		echo ".invisible      { color: #ffffff; font-family: verdana; font-size: ".fs( 12 )."pt}";

		echo ".chat		      { color: #000000; font-family: verdana; font-size: ".fs( 10 )."pt}";

        $button_color = "#006000;";
        $button_hover = "#888888;";

        $mobile_button_color = "#006000;";
        $mobile_button_hover = "#888888;";
        
        $fs2 = fs( 12 );
        $fsm = fs( 12 );
        
		echo ".greenbuttondesktop {cursor: pointer; border: 1px solid ".$button_color."; border-radius: 5px; background: ".$button_color."; color: #ffffff; font-family: verdana; font-size: ".$fs2."pt; ";
		echo "    border-width:1px; padding-left:1px; padding-right:2px; padding-top:1px; display: inline-block; padding-bottom:1px; margin:1px; ";
		echo "    }";

		echo ".greenbuttondesktop:hover {cursor: pointer; border: 1px solid ".$button_hover."; border-radius: 5px; background: ".$button_hover."; color: #ffffff; font-family: verdana; font-size: ".$fs2."pt; ";
		echo "    border-width:1px; padding-left:1px; padding-right:2px; padding-top:1px; display: inline-block; padding-bottom:1px; margin:1px; ";
		echo "    }";

    	echo ".greenbuttonmobile {cursor: pointer; line-height: 12pt; border: solid 1px ".$button_color."; border-radius: 4px; background: ".$mobile_button_color."; color: #FFFFFF; font-family: verdana; font-size: ".$fsm."pt; ";
		echo "    border-width:1px; padding-left:1px; padding-right:1px; padding-top:1px; display: inline-block; padding-bottom:1px; margin:1px; ";
		echo "    }";

		echo ".greenbuttonmobile:hover {cursor: pointer; line-height: 12pt; border:solid 1px ".$button_hover."; border-radius: 4px; background: ".$mobile_button_hover."; color: #FFFFFF; font-family: verdana; font-size: ".$fsm."pt; ";
		echo "    border-width:1px; padding-left:1px; padding-right:1px; padding-top:1px; display: inline-block; padding-bottom:1px; margin:1px; ";
		echo "    }";



		$data['bg'] = $bg;
		$data['rose'] = $rose;

		return ($data);
	}


    function menu_platform()
    {
        echo "<table width='100%'>";
        
        menu_option_platform( "New request", "new_request.php" );

        menu_option_platform( "Request attachments", "request_attachments.php" );

        menu_option_platform( "List requests", "new_requests.php" );
        
        menu_option_platform( "List quotes", "list_quotes.php" );
        
        menu_option_platform( "Completed documents", "completed_documents.php" );

        menu_option_platform( "List invoices", "list_invoices.php" );

        echo "</table>";
    }
    


	function menu_option_platform( $prompt, $filename )
	{
	    $small_link = false;
	    
        $background_color = "#eeeeee";

		if (! low_res_screen())
		{
		    if ($small_link)
            	echo "<tr><td height='38pt' width='120px' align='left' class='menulink' onclick='location=\"/".$filename."\"' style='margin-left: 10px; font-size: 12pt'>&nbsp;&nbsp;&nbsp;".$prompt."&nbsp;&nbsp;&nbsp;</a></td></tr>";
            else
               	echo "<tr><td height='38pt' width='15%' align='left'><a class='menulink2' href='".$filename."'>&nbsp;&nbsp;".$prompt."</a></td><td width='85%'>&nbsp;</td></tr>";
		}
		else
		{
	        if ($this_page == $menu_option_page)
		        $background_color = "#d5d5d5";
		    else
		        $background_color = "#a0a0a0";

			echo "<td width='40%' style='line-height: 42px; background-color: ".$background_color."; border-radius: 10px; color: #ffffff; font-size: 12pt; font-family: verdana; text-decoration: none;' onclick=\"window.location.href='".$filename."'\">&nbsp;&nbsp;&nbsp;".$prompt."</td>";
	    }
	}



		// must have a blank function with this name because it is called by the central validation routine
		
	function additional_validations( $id, $form_name, $newrecord, &$validation_errors, &$screen_data, &$screen_data_error, $cxn )
	{
	    if ($form_name == "mpl_quote")
	    {
	        if ($screen_data['adviser'] == "" && $screen_data['practice'] == "")
	        {
    			$validation_errors = $validation_errors."You must select either a Practice or an Adviser<br>";
				
				$screen_data_error['practice'] = "true";
				$screen_data_error['adviser'] = "true";				
	        }
	    }
	}
	
	
	function additional_screen_initialisations( $id, $newrecord, $form_name, $table_name, &$screen_data, $cxn )
	{
	    if ($form_name == "mpl_quote" && $newrecord == "true")
	    {
	        $screen_data['effective_date'] = date( "d/m/Y" );
	        $screen_data['status'] = "not_sent";
	    }
	    
	    if ($form_name == "mpl_credit_note" && $newrecord == "true")
	    {
	        $screen_data['effective_date'] = date( "d/m/Y" );
	        $screen_data['amount_paid'] = "0";
	    }
	}
	
			// don't delete this function it is called by the general save function
		
	function additional_changes_before_database_save( $id, $newrecord, $form_name, $table_name, &$screen_data, $cxn )
	{
	
		if ($form_name == "task")
		{
			if ($newrecord == "true")
				$screen_data['date_created'] = date("Y-m-d H:i:s");
			
			$screen_data['date_modified'] = date("Y-m-d H:i:s");
		}
	
	}



		// don't put in the common library because there is a different tracking ID for each site
		
		// currently uses the Academic Dating tracking ID
		
	function show_google_translate()
        {
            echo "<td width='15%' valign='top'>";
            echo ' <div id="google_translate_element"></div><script type="text/javascript"> ';
            echo ' function googleTranslateElementInit() { ';
            echo " new google.translate.TranslateElement({pageLanguage: 'en', layout: google.translate.TranslateElement.InlineLayout.SIMPLE, gaTrack: true, gaId: 'UA-97849346-1'}, 'google_translate_element'); ";
            echo ' } ';
            echo ' </script><script type="text/javascript" src="//translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script> ';
            echo "</td>";
        }



        /* send an email to a member */

	function send_external( $to_addr, $subject, $text_body, $html_body, $cxn, $queue )
	{
		$from_name = business_name;
		$from_addr = from_email_address;
		$reply_name = business_name;
		$reply_addr = reply_email_address;

		send_email( $from_name, $from_addr, $to_addr, $reply_name, $reply_addr, $subject, $text_body, $html_body, $cxn, $queue );

		return ($to_addr);
	}



		// Don't put this function in the common library because it's different for SSL and non SSL connections
		
		/* log into the database and return the connection */
		

	function db_login( $database )
	{
		$host="localhost";
		$user="academi1_mlm1";
		$password="plastic1";

        $cxn = new mysqli( $host, $user, $password, $database );

		if ($cxn->connect_errno)
		{
			echo "The system is currently unavailable.<br><br>Please try again in half an hour.";
			
			echo "Error number: ".$cxn->connect_errno."<br>";
			echo "Error text: ".$cxn->connect_error."<br>";

			exit();
		}

		return $cxn;
	}





		// Log into the common database. Must happen AFTER the login to the normal local database $cxn as it's set up for this
		// function only to create a second connection
		
	function db_common_login()
	{
//		$host="localhost";
//		$user="academi1_mlm1";
//		$password="plastic1";


////		if (val( $_SESSION, "site_cxn_common" ) != "")
////			$cxn_common = val( $_SESSION, "site_cxn_common" );
////		else

//		{
//            $cxn_common = new mysqli( $host, $user, $password, "academi1_commondata" );
//          
//			if ($cxn_common->connect_errno)
//			{
//				echo "The system is currently unavailable.<br><br>Please try again in half an hour.";
//				
//				echo "Error number: ".$cxn_common->connect_errno."<br>";
//				echo "Error text: ".$cxn_common->connect_error."<br>";
//
//				exit();
//			}
//
//
//			$cxn_common = mysql_connect( $host, $user, $password, true );			// 'true' to establish a second connection after $cxn. doesn't work without this
//            
//			if ($cxn_common === false)
//			{
//				echo "The system is currently unavailable.<br><br>Please try again in half an hour.";
//				exit();
//			}
//	
//			$stat = mysql_select_db( "academi1_commondata", $cxn_common );
//			
//			if ($stat == false)
//			{
//				$error = mysql_error( $cxn_common );
//				
//				echo "ERROR: can't connect to database: ".$error."<br><br>";
//			}

//			$_SESSION['site_cxn_common'] = $cxn_common;
//		}
//				
//		return $cxn_common;

	}	


		// don't put in the common library because different sites have different color schemes
		
	function form_start( $handler, $param1="", $value1="", $param2="", $value2="", $param3="", $value3="", $param4="", $value4="" )
	{
			//lightskyblue  #cceeff azure
			// lighter color first
			
		echo "<form id='form' name='form' action='".url_encode( $handler, $param1, $value1, $param2, $value2, $param3, $value3, $param4, $value4 )."' method='POST'><table style='border: 1px solid #bbbbbb; background: linear-gradient(#fcfcfc, #e1e1e1)'>\n";
		
//		echo "<form id='form' name='form' action='".url_encode( $handler, $param1, $value1, $param2, $value2, $param3, $value3 )."' method='POST'><table style='border: 1px solid #bbbbbb; background: linear-gradient(mintcream, teal)'>\n";
	}
	
	
    function generate_custom_fields( $newrecord, $form_name, $field_name, $right_side_pane, $screen_data, $screen_data_error, $cxn )
    {
        if ($form_name == "task" || $form_name == "mpl_quote")
        {
            write_update_function();
            
            $number_of_strategies_list = "<option></option><option>1</option><option>2</option><option>3</option><option>4</option><option>5</option><option>6</option><option>7</option><option>8</option><option>9</option><option>10</option><option>11</option><option>12</option>";
        
            $number_of_strategies = $screen_data['number_of_strategies'];
            
        	if ($number_of_strategies != "")
        	{
        		$pos = strpos( $number_of_strategies_list, "<option>".$number_of_strategies."</option>" );
        
        		if ($pos !== false)
        		{
        			$pos = $pos + 8;
        			$number_of_strategies_list = substr( $number_of_strategies_list, 0, $pos - 1 )." selected".substr( $number_of_strategies_list, $pos - 1, strlen( $number_of_strategies_list ) - $pos + 1 );
        		}
        	}
        
        	echo "<tr><td><span class='fprompt'>Number of strategies</span></td><td></td>";
        	
            if ($form_name == "task")
            	echo "<td><select id='number_of_strategies' name='number_of_strategies' class='finput' onchange='UpdateFee();'>".$number_of_strategies_list."</select></td></tr>";

            if ($form_name == "mpl_quote")
            	echo "<td><select id='number_of_strategies' name='number_of_strategies' class='finput' onchange='UpdateFee2();'>".$number_of_strategies_list."</select></td></tr>";
            	
        }    
    }

	
    function write_update_function()
    {
        echo "<script>";
        
        echo "function UpdateFee()";
        
        echo "{";

        echo "  var NumberofStrategies = document.getElementById( 'number_of_strategies' );";

        echo "  var soa_fee = document.getElementById( 'quoted_price' );";

        echo "  var paraplanner_commission = document.getElementById( 'paraplanner_commission' );";

        echo "  soa_fee.value = ".fee_calc_formula;

        echo "  paraplanner_commission.value = ".commission_calc_formula;

        echo "  checker_commission.value = ".checker_commission_calc_formula;




//        echo "  if (NumberofStrategies.value == '1')    { soa_fee.value = '360'; paraplanner_commission.value='252'; }";
//        echo "  if (NumberofStrategies.value == '2')    { soa_fee.value = '395'; paraplanner_commission.value='277'; }";

        echo "}";
        

        echo "function UpdateFee2()";
        
        echo "{";

        echo "  var NumberofStrategies = document.getElementById( 'number_of_strategies' );";

        echo "  var amount = document.getElementById( 'amount' );";

        echo "  amount_ex_gst.value = ".fee_calc_formula;
        
        
//        echo "  if (NumberofStrategies.value == '2')    { amount_ex_gst.value = '395'; }";
//        echo "  if (NumberofStrategies.value == '3')    { amount_ex_gst.value = '435'; }";

        echo "   gst.value =  parseInt(amount_ex_gst.value) * 0.1; ";
        
        echo "   if (gst.value.substr(gst.value.length-2, 1 ) == '.') ";
        echo "      gst.value = gst.value + '0'; ";

        echo "   total.value =  parseFloat(amount_ex_gst.value) + parseFloat(gst.value); ";

        echo "   if (total.value.substr(total.value.length-2, 1 ) == '.') ";
        echo "      total.value = total.value + '0'; ";
        
        echo "}";

        echo "</script>";
    }        
	
?>