<?php

	include "library.php";

	include forms_library;

	include ad_forms_library;

	include mail_library;


	$cxn = start_code();

    exit_if_search_bot();

    exit_if_session_expired( $cxn );
    

			/* get variables */

	$advertiser_id = val( $_SESSION, "advertiser_id" );

	$newprofile = val( $_SESSION, "newadvertiserprofile" );


	crash_if_missing( $newprofile, "newprofile missing in save advertiser profile, username = ".val( $_POST, 'username' ), $cxn );


	if ($newprofile != "true")
		crash_if_missing( $advertiser_id, "advertiser_id missing in save advertiser profile", $cxn );

	
			/* define timestamps */


	$date_today = date( "Y-m-d H:i:s" );


	$ok = validate_form( $advertiser_id, $newprofile, "advertiser_profile", $screen_data, $screen_data_errors, $validation_errors, $cxn );		


	if ($validation_errors != "")
	{	
				/* must happen before print output */
		jump_to_page( "edit_advertiser.php", "newadvertiserprofile", $newprofile );
			
		exit();
	}


	page_header( "", $cxn );



	$email_verification_code = substr(md5(time()), 0, 8);


	$query = "SELECT region FROM ".common_data_database_name.".country WHERE ".common_data_database_name.".country.display_name = '".$screen_data['country']."'";

	$result = run_query( $query, $cxn );

	if (query_num_rows( $result, $cxn ) > 0)
	{
		$data = get_row( $result );

    	$screen_data['region'] = $data['region'];
	}


		/* save the record to the database */

	if ($newprofile == "true")
	{
		$last_login = date( "Y-m-d H:i:s" );

		$source = val( $_SESSION, 'source' );

		if ($source == "")
			$source = ".blank";

		$ip_country = get_ip_country( $cxn );

		$ip_country = str_replace( "'", "''", $ip_country );
		                                           

		if ($screen_data['email_address'] == "mark.mcilroy@outlook.com")
			$system_user = "yes";
		else
			$system_user = "no";
		


			// still save the profile in case there are two member's with the same name
			
			
		$screen_data['date_created'] = $date_today;
		$screen_data['date_modified'] = $date_today;
		$screen_data['ip_country'] = $ip_country;
		$screen_data['system_user'] = $system_user;
		$screen_data['source'] = $source;
		$screen_data['last_login'] = $date_today;
		$screen_data['locked'] = "no";
		$screen_data['deleted'] = "no";
		$screen_data['returned_mail'] = "no";		
		$screen_data['login_attempts'] = "0";
		$screen_data['number_of_logins'] = "0";		
		$screen_data['email_address_valid'] = "no";
		$screen_data['email_verification_code'] = $email_verification_code;
		$screen_data['signup_device'] = device_type();
		$screen_data['password'] = trim( $screen_data['password'] );

//  		$screen_data['interests'] = str_insert_spaces( $screen_data['interests'] );

		$username = $screen_data['username'];
		$email_address = $screen_data['email_address']; 
		$country = $screen_data['country']; 
		

		save_form_data_to_database( $advertiser_id, $newprofile, "advertiser_profile", "advertiser_profile", $screen_data, $cxn );
		


			/* update handle history */

		$query = "SELECT id FROM advertiser_profile WHERE username = '".$username."'";

		$result = run_query( $query, $cxn );

		$data = get_row( $result );

		$new_id = $data['id'];


			/* save the username history */

		$query = "INSERT INTO advertiser_username_history (advertiser_id, username, date_assigned) VALUES (".$new_id.", '".$username."', '".$date_today."' )";

		$result = run_query( $query, $cxn );


			/* save the email history */

		$query = "INSERT INTO advertiser_email_history (advertiser_id, email_address, date_entered) VALUES (".$new_id.", '".$email_address."', '".$date_today."' )";

		$result = run_query( $query, $cxn );



//			/* log any current user out to avoid confusion about who's account you're in */
//
//		$_SESSION['id'] = "";



//		$query = "INSERT INTO account_activity (member_id, event, event_datetime) VALUES (".$new_id.", 'profile created', '".date("Y-m-d H:i:s")."')";
//		$result = run_query( $query, $cxn );
		

			// send this last in case it crashes and prevents storing handle history and other records
			
		if ($email_address != "")
    		send_advertiser_verification_email( $new_id, $email_verification_code, "urgent", $cxn );
		

//		echo black( "Successfully saved<br><br>" );

	}
	else
	if ($newprofile == "false")
	{
		$new_id = $id;


			/* update handle history  */

		$query = "SELECT * FROM advertiser_profile WHERE id = ".$advertiser_id;

		$result = run_query( $query, $cxn );

		$data = get_row( $result );

		$prev_email_address = $data['email_address'];
		$email_address_valid = $data['email_address_valid'];

//    		$screen_data['interests'] = str_insert_spaces( $screen_data['interests'] );

		$username = $screen_data['username'];
		
		if ($data['username'] != $username)
		{
			$query = "INSERT INTO advertiser_username_history (advertiser_id, username, date_assigned) VALUES (".$id.", '".$username."', '".$date_today."')";

			$result = run_query( $query, $cxn );
		}


		$email_address = $screen_data['email_address'];

		if ($prev_email_address != $email_address)
		{
			$screen_data['email_address_valid'] = "no";
		    $screen_data['returned_mail'] = "no";					


				/* save the email history */

			$query = "INSERT INTO advertiser_email_history (advertiser_id, email_address, date_entered) VALUES (".$id.", '".$email_address."', '".$date_today."' )";

			$result = run_query( $query, $cxn );
		}


		$screen_data['date_modified'] = $date_today;
		$screen_data['last_login'] = $date_today;



			// note: don't update the email verification code or there will be mismatches when the member edits their profile and saves it

		save_form_data_to_database( $advertiser_id, $newprofile, "advertiser_profile", "advertiser_profile", $screen_data, $cxn );



		$result = run_query( $query, $cxn );


			/* change of email adress */
			
		if ($prev_email_address != $email_address && $email_address != "")
		{
			$query = "SELECT email_verification_code FROM advertiser_profile WHERE id = ".$id;

			$result = run_query( $query, $cxn );

			$data = get_row( $result );

			$email_verification_code = $data['email_verification_code'];
		
			echo black( "<br>You have changed your email address.<br><br>A verification email should arrive in your email inbox shortly.<br><br>" );
			
			echo black( "You will need to click on the link in the verification email to activate your profile<br><br>" );
			
			echo black( "Please note that if you use BitBounce email filtering your site emails will not be delivered and you will not be able to use the site.<br><br>" );

			send_advertiser_verification_email( $id, $email_verification_code, "urgent", $cxn );
		}

		echo black( "<br>Successfully saved<br><br>" );

	}
	else
		crash( "Internal Error: invalid newprofile flag in save_profile", $cxn );


		
	if ($newprofile == "true")
    {
       		
		$_SESSION['advertiser_id'] = $new_id;

		echo "<br>";

		echo "Profile saved successfully.<br><br>";
           
        if ($email_address != "")
        {
		    echo black( "<br>You will shortly receive a verification email from ".sitename.". You will need to click on the link in the email to activate your account.<br><br>" );
			
			echo red( "<br>Please check the Junk/Spam folders in your personal email inbox for the email address verification message.<br><br><br>" );
			
			echo black( "Please note that on some email systems, such as BitBounce, you will need to whitelist the domain ".domain." to receive the site emails.<br><br>" );
			
        }

		echo "<br>";


			// conversions tracking code for new adwords account admin@academicdating.net

            // Google site tage library code
            
//            echo "<script async>";
                                    // 'value': 1.0,   'currency': 'USD'
                                    
//            echo "gtag('event', 'conversion', {'send_to': 'AW-851976106/JKL_COXqoHEQqr-glgM', 'event_category': 'engagement', 'event_label': 'Academic Dating new member'});";

//            echo "gtag('event', 'sign_up', {'send_to': 'MLMGoogleAnalytics', 'event_category': 'ecommerce', 'event_label': 'Academic Dating new member'});";

//            echo "</script>";


                // wait to load the confirmation page so that the conversion tag event can send
                
//            echo "<script>";

//            echo "var start = new Date().getTime();";

//            echo "while (new Date().getTime() - start < 5000) ;";

//            echo "</script>";
    		
    		
		        // Tag manager code
		        
//            echo "<script> dataLayer.push({'event':'Academic Dating new member'}); </script>";


        echo "<br>";
        echo "<br>";

    }
    else
    {
        echo "<br>";
    }


	echo "<a class='glink' href='".url_encode( "/" )."'>Home Page</a>";		


    echo "<br><br><br><br><br>";




    echo "</body>";
	
    echo "</html>";

?>