<?php

	include "library.php";

	include forms_library;

	include ad_forms_library;


	$cxn = start_code();

    exit_if_search_bot();

    exit_if_session_expired( $cxn );
    

			/* get variables */

	$jobseeker_id = val( $_SESSION, "jobseeker_id" );

	$newprofile = val( $_GET, "newprofile" );
	
	
	$_SESSION['newprofile'] = $newprofile;


			
		/* check parameters */

	crash_if_missing( $newprofile, "newprofile missing in edit_profile", $cxn );

	
		/* if the user is not logged in them direct them to the login page then back to here */

	if ($newprofile == "false" && $jobseeker_id == "")
	{
		$_SESSION['nextpage'] = url_encode( "edit_jobseeker_profile.php", "newprofile", $newprofile );

	    jump_to_page( "jobseeker_login.php" );		/* must happen before print output */

		exit();
	}

	

		/* this form edit window operates in three modes - a blank screen for a new
		profile, editing retrieved data for editing a profile, and editting the previously
		entered data after a validation error
		*/

		/* set the validation error flag  */

	if (val( $_SESSION, 'validation_error' ) == "true")
		$validation_error = "true";
	else
		$validation_error = "false";	/* blank or set to false */

//	$_SESSION['validation_error'] = "false";


		/* start the page */

	page_header( "Jobseeker Profile", $cxn );			
	

//	echo blue( "On completing your profile, you will have the option of only receiving messages from member's who's account details have been verified by the site.<br><br>" );

	if ($newprofile == "true")
		echo blue( "To join the site please complete your profile information on this page and click on the 'Save' button at the bottom of the page<br><br><br>" );
	else
        echo blue( "Click on the 'Save' button at the bottom of the page to save your changes<br><br><br>" );


	initialise_screen_data( $jobseeker_id, $newprofile, "jobseeker_profile", "jobseeker_profile", $validation_error,  $screen_data, $screen_data_error, $cxn );


	if (val( $_SESSION, "validation_errors" ) != "")
		echo red( "<b>Please correct the errors below</b><br><br>".$_SESSION['validation_errors']."<br><br>" );


    form_start( "save_jobseeker_go.php" );

	write_yellow_input_boxes();
	
	generate_screen_fields_one_pane( $newprofile, "jobseeker_profile", "false", $screen_data, $screen_data_error, $cxn );


	echo "</table><table width='100%'><td width='15%'></td><td width='20%'></td><td width='65%'></td></tr>";

	if (! low_res_screen())
		echo "<tr><td></td><td align='center'><br><br>";
	else
		echo "<tr><td colspan='3' align='center'><br><br>";
	
	show_green_button_submit( "Save", 80 );
	
	echo "</td></tr>";	


	if (! low_res_screen())
		echo "<tr><td></td><td align='center'><br><br>";
	else
		echo "<tr><td colspan='3' align='center'><br><br>";

	if ($newprofile == "false")
		show_green_button( "Delete Profile", 135, "delete_profile.php" );		


	echo "</td></tr>";

	form_end();

    echo "<br>";




    echo "</body>";
	
    echo "</html>";

    
?>