<?php

		/* Process a payment notification transaction from PayPal */

	include "library.php";

	$cxn = start_code( true );
	

	$tx = val( $_POST, "txn_id" );
	$amt = val( $_POST, "mc_gross" );
	$payment_status = val( $_POST, "payment_status" );
	$payment_type = val( $_POST, "payment_type" );
	$custom = val( $_POST, "custom" );

	$txn_type = val( $_POST, "txn_type" );

	/* payment statuses
		Canceled-reversal
		Completed
		Denied
		Expired
		Failed
		In-Progress
		Partially-Refunded
		Pending
		Refunded
		Reversed
		Processed
		Voided
	*/

	/* payment type
		echeck
		instant
	 */
	$transaction_date = date("Y-m-d H:i:s");

	$data = split_csv( $custom );

	$type = $data[0];
	$member_id = $data[1];
	$credits_code = $data[2];
	$magic = $data[3];

	if (md5( $member_id."|".$credits_code ) != $magic)
		crash( "Bad magic code in payment check back end, tx=".$tx.", member id =".$member_id, $cxn );

	if ($type == "donation")
	{
		/* save the transaction */

		$query = "INSERT INTO transaction (member_id, transaction_date, amount, credits, tx, payment_status, payment_type, credits_code, custom, type) VALUES (".$member_id.", '".$transaction_date."', ".$amt.", 0, ".$tx."', '".$payment_status."', '".$payment_type."', '".$credits_code."', '".$custom."', 'donation')";
		$result = run_query( $query, $cxn );
	}
	else
	if ($type == "subscription")
	{
		$status = $payment_status.":".$txn_type;

		if ($amt == "")
			$amt = 0;

			/* save this transaction */

		$query = "INSERT INTO transaction (member_id, transaction_date, amount, credits, tx, payment_status, payment_type, credits_code, custom, type) VALUES (".$member_id.", '".$transaction_date."', ".$amt.", 0, '".$tx."', '".$payment_status."', '".$payment_type."', '".$credits_code."', '".$custom."', '".$txn_type."')";
		$result = run_query( $query, $cxn );


			/* update member record */

		if ($txn_type == "subscr-signup" || $txn_type == "subscr_signup")
		{
			$query = "UPDATE profile SET membership_subscription_type = 'subscription', subscription_valid = 'yes' WHERE id = ".$member_id;
			$result = run_query( $query, $cxn );
		}

		if ($txn_type == "subscr-cancel" || $txn_type == "subscr_cancel")
		{
			$query = "UPDATE profile SET membership_subscription_type = 'basic', subscription_valid = 'no' WHERE id = ".$member_id;
			$result = run_query( $query, $cxn );
		}
	}
	else
	{
		if ($amt != "1.20" && $amt != "8.00" && $amt != "20.00"	 && $amt != "40.00" && $amt != "80.00")
			crash( "Corrupt payment amount ".$amt.", tx=".$tx.", member id =".$member_id.", custom =".$custom, $cxn );


			/* get the credits code to verify the transaction */

		$query = "SELECT credits_code, credits_balance FROM profile WHERE id = ".$member_id;

		$result = run_query( $query, $cxn );

		$data2 = get_row( $result );

	//	if ($data2['credits_code'] == "")
	//		$payment_status = "[already processed] ".$payment_status;

		if ($data2['credits_code'] == "")
			crash( "Credits code is null, tx=".$tx.", member id =".$member_id.", custom =".$custom, $cxn );

		if ($data2['credits_code'] != "" && $data2['credits_code'] != $credits_code)
			crash( "Corrupt credits code, tx=".$tx.", member id =".$member_id.", custom =".$custom, $cxn );


			/* calculate the number of credits */

		if ($amt == "1.20")
			$num_credits = 1;
		else
		if ($amt == "8.00")
			$num_credits = 10;
		else
		if ($amt == "20.00")
			$num_credits = 25;
		else
		if ($amt == "40.00")
			$num_credits = 50;
		else
		if ($amt == "100.00")
			$num_credits = 100;

		$credits_balance = $data2['credits_balance'] + $num_credits;

			/* save the transaction */

		$query = "INSERT INTO transaction (member_id, transaction_date, amount, credits, tx, payment_status, payment_type, credits_code, custom, type) VALUES (".$member_id.", '".$transaction_date."', ".$amt.", ".$num_credits.", '".$tx."', '".$payment_status."', '".$payment_type."', '".$credits_code."', '".$custom."', 'purchase')";
		$result = run_query( $query, $cxn );


			/* update the profile and credits record */
			/* credit on the initial hit even if it's an e-cheque */
			/* for e-cheques this will be called a second time but don't create new records */

		if (($payment_type == "instant" && $payment_status == "Completed") ||
			($payment_type == "echeck" && $payment_status == "Pending") ||
			$payment_status == "Processed")
		{
			$query = "UPDATE profile SET credits_balance = ".$credits_balance." WHERE id = ".$member_id;
			$result = run_query( $query, $cxn );

			$query = "UPDATE profile SET credits_code = NULL WHERE id = ".$member_id;
			$result = run_query( $query, $cxn );

			$event_datetime = date("Y-m-d H:i:s");


				/* update the credits record */

			$query = "INSERT INTO credits (member_id, event, number, event_datetime, tx) VALUES (".$member_id.", 'purchase', ".$num_credits.", '".$event_datetime."', '".$tx."')";
			$result = run_query( $query, $cxn );
		}
	}

?>
