<?php

	include "library.php";

	$cxn = start_code();

    exit_if_search_bot();

    exit_if_session_expired( $cxn );


    $effective_date = val( $_POST, "effective_date" );
 
	$report_effective_date = convert_date_to_yyyymmdd( $effective_date, "dd/mm/yyyy", $cxn );

 
	page_header( "Leave balances", $cxn );

	echo black( "As at: ".$effective_date."<br><br><br><br>" );



    echo "<table>";
    
    echo "<tr>";
    echo "<td align='center' style='margin: 5px;'>".blue( "Employee name" )."</td>";
    echo "<td align='center' style='padding-left: 35px;'>".blue( "Accumulated<br>annual<br>leave" )."</td>";
    echo "<td align='center' style='padding-left: 35px;'>".blue( "Annual<br>leave<br>taken" )."</td>";
    echo "<td align='center' style='padding-left: 35px;'>".blue( "<b>Annual<br>leave<br>owing</b>" )."</td>";
    echo "<td align='center' style='padding-left: 35px;'>".blue( "Accumulated<br>personal<br>leave" )."</td>";
    echo "<td align='center' style='padding-left: 35px;'>".blue( "Personal<br>leave<br>taken" )."</td>";
    echo "<td align='center' style='padding-left: 35px;'>".blue( "<b>Personal<br>leave<br>owing</b>" )."</td>";
    echo "</tr>";

    echo "<tr><td>&nbsp;</td></tr>";
 
 
    $query = "SELECT * FROM employee WHERE start_date <= '".$report_effective_date."' ORDER BY display_name";
 
    $result = run_query( $query, $cxn );


  	for ($i=0; $i < query_num_rows( $result ); $i++)
    {
	    $data = get_row( $result );
    
        $employee_name = $data['display_name'];
	       
        $accumulated_annual_leave = 0;
	    $accumulated_personal_leave = 0;
	    $annual_leave_taken = 0;
	    $personal_leave_taken = 0;
	    
 
        $query2 = "SELECT * FROM pay_run_line INNER JOIN pay_run ON pay_run_line.pay_run_id = pay_run.id WHERE employee_name = '".$employee_name."' AND pay_run.end_of_period <= '".$report_effective_date."'";
        
        $result2 = run_query( $query2, $cxn );
   
    
      	for ($j=0; $j < query_num_rows( $result2 ); $j++)
        {
	        $data2 = get_row( $result2 );
	        
	        $accumulated_annual_leave += $data2['annual_leave_accumulated_this_period'];
	        $accumulated_personal_leave += $data2['personal_leave_accumulated_this_period'];	           
        }
        
        
        $query3 = "SELECT * FROM leave_taken WHERE employee_name = '".$employee_name."' AND effective_date <= '".$report_effective_date."'";
        
        $result3 = run_query( $query3, $cxn );
   
    
      	for ($k=0; $k < query_num_rows( $result3 ); $k++)
        {
	        $data3 = get_row( $result3 );
	        
	        if ($data3['leave_type'] == "Annual")
	            $annual_leave_taken += $data3['hours_taken'];
	            
	        if ($data3['leave_type'] == "Personal")
	            $personal_leave_taken += $data3['hours_taken'];
        }
         
        
        echo "<tr>";
        echo "<td>".black( $employee_name )."</td>";
        echo "<td align='right'>".black( number_format( $accumulated_annual_leave, 2 ) )."</td>";
        echo "<td align='right'>".black( number_format( $annual_leave_taken, 2 ) )."</td>";
        echo "<td align='right'>".black( "<b>".number_format( $accumulated_annual_leave - $annual_leave_taken, 2 )."</b>" )."</td>";
        echo "<td align='right'>".black( number_format( $accumulated_personal_leave, 2 ) )."</td>";
        echo "<td align='right'>".black( number_format( $personal_leave_taken, 2 ) )."</td>";
        echo "<td align='right'>".black( "<b>".number_format( $accumulated_personal_leave - $personal_leave_taken, 2 )."</b>" )."</td>";
        echo "</tr>";
    }
    
    
    echo "</table>";


?>