<?php

	define( "common_data_database_name", "academi1_commondata" );
	define( "sitename", "ACV HR" );
//	define( "from_email_address", "mark.mcilroy@melbourneparaplanning.com" );
//	define( "reply_email_address", "mark.mcilroy@melbourneparaplanning.com" );
//	define( "manager_email_address", "mark.mcilroy@melbourneparaplanning.com" );
	define( "error_log_filename", "/home/academi1/public_html/acv_hr/error_log.txt" );

	define( "account_salaries_paid",                        "Wages and Salaries (E477)"             );
	define( "account_bank",                                 "Bank account (1047)"                   );
	define( "account_payg_due_to_be_submitted_to_the_ato",  "PAYG due to be submitted to the ATO (L1046)" );
    define( "account_superannuation_due",                  "Superannuation due (L1061)"                  );


	include "/home/academi1/public_html/common_code/common_library.php";
	include "/home/academi1/public_html/common_code/forms_library.php";



    			/* startup code to be called at the top of each file */

	function start_code( $first=false, $db="" )
	{
			/* set up paths */

		$domain = val( $_SERVER, "HTTP_HOST" );

		session_start();

		$_SESSION['domain'] = $domain;

		$_SESSION['pathroot'] = "/home/academi1/public_html/accounts";


			/* set up variables */

		$database = "academi1_acv_hr";


		$user = val( $_GET, "user" );


			/* remember user across pages */

			/* set config options */

		ini_set( "error_log", $_SESSION['pathroot']."/error_log.txt" );

			// don't enable these options as they my expose technical details of the site to viewers
		ini_set( "display_errors", "on" );
		ini_set( "display_startup_errors", "on" );

        error_reporting( E_ALL & ~E_DEPRECATED );
        
		ini_set( "gc_maxlifetime", 1*60*60 );		/* set session timeout to 1 hour */

		ini_set( "date.timezone", "Australia/Melbourne" );
		
//		if (! $first )
//			check_url();

		$cxn = db_login( $database );


		return ($cxn);
	}



		/* generate the heading line for a page */


		/* NOTE: don't call this before any jump_to_page's or the jumps wont work */

	function page_header( $heading, $cxn )
	{
    	echo "<style> html, body {";
    	echo "margin:0;";
    	echo "padding:0;";
    	echo "}";
    	echo "</style>";


        if (! low_res_screen())    
        	echo "<table cellpadding='0' cellspacing='0' width='100%'><tr><td style='line-height: 45px; font-family: Calibri; font-size: 18pt; color: #ffffff; background-color: ".acv_bg_color."' align='left'>&nbsp;&nbsp;&nbsp;ACV HR</td></tr></table>";
        else
        	echo "<table cellpadding='0' cellspacing='0' width='100%'><tr><td style='line-height: 30px; font-family: Calibri; font-size: 14pt; color: #ffffff; background-color: ".acv_bg_color."' align='left'>&nbsp;&nbsp;&nbsp;ACV HR</td></tr></table>";

	    echo "<br>";

//        if (low_res_screen())    
//    	    echo "<br>";


        $_SESSION['sitename'] = sitename;

		$_SESSION['session_active'] = "yes";
		
		echo "<html><head><meta name='viewport' content='width=device-width, initial-scale=1.0'>";

		echo "<meta http-equiv='Content-Type' content='text/html; charset=UTF-8'>";

		echo '<link rel="shortcut icon" href="/favicon.ico" type="image/x-icon">';
		echo '<link rel="icon" href="/favicon.ico" type="image/x-icon">';



			/* define styles */

		echo "<style>";


		write_acv_styles();
		
		define_styles();


		echo "</style>";


        if (val( $_SESSION, "screen_width" ) == "")
            write_screen_parameters_function();


		if ($heading != "")
			echo "<title>".sitename.": ".$heading."</title></head>";
		else
			echo "<title>".sitename."</title></head>";


        if (val( $_SESSION, "screen_width" ) == "")
    		echo "<body onload='js_set_screen_parameters();'>";
    	else
    		echo "<body>";


		echo "<table width='100%'><tr><td width='2%'>&nbsp</td><td width='98%'>";

		if ($heading != "")
		{
    		echo "<table width='100%' cellpadding='0' cellspacing='0'><tr><td width='80%' class='pgheading' valign='center' style='padding: 0px; border-collapse: collapse;'>".$heading."</td>";

			echo "<td width='20%' align='center'>";

			show_green_button( "Home", 80, "index.php", "internaljump", "true" );
			
			echo "</td></tr></table>";
				
			echo "<span style='font-size: 6pt'>&nbsp;<br></span>";
		}
	}


		/* define the CSS styles */

	function define_styles()
	{
		echo "body   		{ color: #000000; verdana; font-size: ".fs( 12 )."pt}";

		echo "a:visited	{color: #0000bb; text-decoration: underline}";
		echo "a:link	{color: #0000bb; text-decoration: underline}";

		echo "a.menubaritem			{color: #000000; font-size:".fs( 12 )."pt; font-family:verdana; text-decoration:none}";
		echo "a.menubaritem:visited {color: #000000; font-size:".fs( 12 )."pt; font-family:verdana; text-decoration:none}";
		echo "a.menubaritem:link	{color: #000000; font-size:".fs( 12 )."pt; font-family:verdana; text-decoration:none}";
		echo "a.menubaritem:hover   {color: #000000; font-weight: bold; background-color: #eeeeee; font-size:".fs( 12 )."pt; font-family:verdana; text-decoration: none}";

		echo ".hl {cursor: pointer; color: #bb0000; background-color: #eeeeee; font-size:".fs( 12 )."pt; font-family:verdana; text-decoration: none}";
		echo ".uhl {color: #0000bb; font-size:".fs( 12 )."pt; font-family:verdana; text-decoration: none}";

		echo ".gblack         { color: #000000; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".gblue          { color: #0000bb; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".gred           { color: #bb0000; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".ggreen         { color: #00bb00; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".gwatermark     { color: #999999; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".gpink          { color: #FF69B4; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".gmidgreen      { color: #008000; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".gwhite         { color: #ffffff; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".ggrey          { color: #bbbbbb; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".gbrown         { color: #bf7d40; font-family: verdana; font-size: ".fs( 12 )."pt}";

		echo ".numbergreen    { color: #00a000; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".numberred      { color: #ff0000; font-family: verdana; font-size: ".fs( 12 )."pt}";


		if (! low_res_screen())
        {				
			echo ".fprompt        { padding-left: 2px; margin-right: 3px; color: #000000; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".finput         { padding-left: 2px; margin-right: 3px; color: #000000; padding-left: 2px; border-style: solid; border-width: 1px; border-color: #cccccc; font-family: verdana; font-size: ".fs( 12 )."pt}";			
			echo ".fradio         { padding-left: 2px; margin-right: 3px; color: #000000; font-family: verdana; font-size: ".fs( 12 )."pt}";

			echo ".fprompt_error  { padding-left: 2px; color: #ff0000; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".finput_error   { padding-left: 2px; color: #000000; padding-left: 2px; border-style: solid; border-width: 1px; border-color: #cccccc; background-color: #ff9999; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".fradio_error   { padding-left: 2px; color: #000000; background-color: #ff9999; font-family: verdana; font-size: ".fs( 12 )."pt}";
        }
        else
        {
			echo ".fprompt        { color: #000000; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".finput         { color: #000000; padding-left: 2px; border-style: solid; border-width: 1px; border-color: #cccccc; font-family: verdana; font-size: ".fs( 12 )."pt}";			
			echo ".fradio         { color: #000000; font-family: verdana; font-size: ".fs( 12 )."pt}";

			echo ".fprompt_error  { color: #ff0000; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".finput_error   { color: #000000; padding-left: 2px; border-style: solid; border-width: 1px; border-color: #cccccc; background-color: #ff9999; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".fradio_error   { color: #000000; background-color: #ff9999; font-family: verdana; font-size: ".fs( 12 )."pt}";
        }

		echo ".dprompt        { padding-left: 2px; margin-right: 3px; color: #0000bb; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".dtext          { padding-left: 2px; margin-right: 3px; color: #000000; font-family: verdana; font-size: ".fs( 12 )."pt}";

		echo ".paraheading    { color: ".acv_bg_color."; font-family: verdana; font-size: ".fs( 12 )."pt}";

		echo ".mainmenuheading    { color: #000000; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".mainmenuitem			{color: #0000bb; font-size: ".fs( 12 )."pt; font-family:verdana; text-decoration:none}";
		echo ".mainmenuitem:visited	{color: #0000bb; font-size: ".fs( 12 )."pt; font-family:verdana; text-decoration:none}";
		echo ".mainmenuitem:link	{color: #0000bb; font-size: ".fs( 12 )."pt; font-family:verdana; text-decoration:none}";
		echo ".mainmenuitem:hover	{cursor: pointer; color: #00b000; font-size: ".fs( 12 )."pt; font-family:verdana; text-decoration:none; background: #eeeeee;}";

	    echo ".menulink2      	{color: #000000; border-style: none; padding-left: 0; padding-right: 0; font-size: 13pt; font-family: Calibri; text-decoration:none}";
	    echo ".menulink2:link  	{color: #000000; border-style: none; padding-left: 0; padding-right: 0; font-size: 13pt; font-family: Calibri; text-decoration:none}";
	    echo ".menulink2:hover	{color: #bbbbbb; cursor: pointer; border-style: none; padding-left: 0; padding-right: 0; font-size: 13pt; font-family: Calibri; text-decoration:none}";			    

		echo ".pgheading      { color: ".acv_bg_color."; font-family: verdana; font-size: ".fs( 18 )."pt}";
//		echo ".pgheading      { color: #1E90FF; font-family: verdana; font-size: ".fs( 30 )."pt}";
		echo ".homeheading    { color: #0000bb; font-family: times; font-size: ".fs( 12 )."pt}";

		echo ".glink		  { color: #0000bb; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".glink:visited  { color: #0000bb; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".glink:link     { color: #0000bb; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".glink:hover    { color: #000080; font-family: verdana; font-size: ".fs( 12 )."pt}";

		echo ".reportlink		   { text-decoration: none; color: #0000bb; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".reportlink:visited  { text-decoration: none; color: #0000bb; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".reportlink:link     { text-decoration: none; color: #0000bb; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".reportlink:hover    { text-decoration: underline; color: #0000bb; font-family: verdana; font-size: ".fs( 12 )."pt}";

		echo ".pinklink:visited { text-decoration: none; color: #FF69B4; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".pinklink:link  { text-decoration: none; color: #FF69B4; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".pinklink:hover { text-decoration: underline; color: #FF69B4; font-family: verdana; font-size: ".fs( 12 )."pt}";

		echo ".redlink:visited { text-decoration: none; color: #ff0000; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".redlink:link  { text-decoration: none; color: #ff0000; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".redlink:hover { text-decoration: underline; color: #ff0000; font-family: verdana; font-size: ".fs( 12 )."pt}";
		
		echo ".lpinklink:visited { text-decoration: none; color: #ffd7ff; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".lpinklink:link  { text-decoration: none; color: #ffd7ff; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".lpinklink:hover { text-decoration: underline; color: #ffd7ff; font-family: verdana; font-size: ".fs( 12 )."pt}";

		echo ".whitelink:visited { text-decoration: underline; color: #ffffff; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".whitelink:link  { text-decoration: underline; color: #ffffff; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".whitelink:hover { text-decoration: underline; color: #ffffff; font-family: verdana; font-size: ".fs( 12 )."pt}";

		echo ".bluelink:visited { text-decoration: underline; color: #0000bb; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".bluelink:link  { text-decoration: underline; color: #0000bb; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".bluelink:hover { text-decoration: underline; color: #0000bb; font-family: verdana; font-size: ".fs( 12 )."pt}";
		
	}



		// must have a blank function with this name because it is called by the central validation routine
		
	function additional_validations( $id, $form_name, $newrecord, &$validation_errors, &$screen_data, &$screen_data_error, $cxn )
	{
	    if ($form_name == "mpl_quote")
	    {
	        if ($screen_data['adviser'] == "" && $screen_data['practice'] == "")
	        {
    			$validation_errors = $validation_errors."You must select either a Practice or an Adviser<br>";
				
				$screen_data_error['practice'] = "true";
				$screen_data_error['adviser'] = "true";				
	        }
	    }
	}
	
	
	function additional_screen_initialisations( $id, $newrecord, $form_name, $table_name, &$screen_data, $cxn )
	{
	    if ($form_name == "hr_hours_worked" && $newrecord == "true")
	    {
	        $screen_data['superannuation_on_this'] = "on";
	    }
	    
	    if ($form_name == "mpl_credit_note" && $newrecord == "true")
	    {
	        $screen_data['effective_date'] = date( "d/m/Y" );
	        $screen_data['amount_paid'] = "0";
	    }
	}
	
			// don't delete this function it is called by the general save function
		
	function additional_changes_before_database_save( $id, $newrecord, $form_name, $table_name, &$screen_data, $cxn )
	{
	
		if ($form_name == "task")
		{
			if ($newrecord == "true")
				$screen_data['date_created'] = date("Y-m-d H:i:s");
			
			$screen_data['date_modified'] = date("Y-m-d H:i:s");
		}
	
	}



		// don't put in the common library because there is a different tracking ID for each site
		
		// currently uses the Academic Dating tracking ID
		
	function show_google_translate()
        {
            echo "<td width='15%' valign='top'>";
            echo ' <div id="google_translate_element"></div><script type="text/javascript"> ';
            echo ' function googleTranslateElementInit() { ';
            echo " new google.translate.TranslateElement({pageLanguage: 'en', layout: google.translate.TranslateElement.InlineLayout.SIMPLE, gaTrack: true, gaId: 'UA-97849346-1'}, 'google_translate_element'); ";
            echo ' } ';
            echo ' </script><script type="text/javascript" src="//translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script> ';
            echo "</td>";
        }



        /* send an email to a member */

	function send_external( $to_addr, $subject, $text_body, $html_body, $cxn, $queue )
	{
		$from_name = business_name;
		$from_addr = from_email_address;
		$reply_name = business_name;
		$reply_addr = reply_email_address;

		send_email( $from_name, $from_addr, $to_addr, $reply_name, $reply_addr, $subject, $text_body, $html_body, $cxn, $queue );

		return ($to_addr);
	}



		// Don't put this function in the common library because it's different for SSL and non SSL connections
		
		/* log into the database and return the connection */
		

	function db_login( $database )
	{
		$host="localhost";
		$user="academi1_mlm1";
		$password="plastic1";

        $cxn = new mysqli( $host, $user, $password, $database );

		if ($cxn->connect_errno)
		{
			echo "The system is currently unavailable.<br><br>Please try again in half an hour.";
			
			echo "Error number: ".$cxn->connect_errno."<br>";
			echo "Error text: ".$cxn->connect_error."<br>";

			exit();
		}

		return $cxn;
	}



    function sign_format( $number, $text )
    {
        if ($number >= 0)
            return( "<span class='numbergreen'>".$text."</span>" );
        else
            return( "<span class='numberred'>".$text."</span>" );
    }
    
    
    
        // sum of a transaction type within date range
        
    function get_transaction_total( $type, $start_date, $end_date, $cxn )
    {
    	$query = "SELECT sum(net_amount) as total FROM transaction INNER JOIN accounts ON accounts.display_name = transaction.account WHERE accounts.type = '".$type."' and effective_date >= '".$start_date."' AND effective_date <= '".$end_date."'";

    	$result = run_query( $query, $cxn );

    	if (query_num_rows( $result ) == 0)
            $total = 0;
        else
        {
		    $data = get_row( $result );

    		$total = $data['total'];
        }

        return ($total);
    }
    
    
    
    function get_expense_allocation_pa( $effective_date, $cxn )
    {
    	$query = "SELECT expense_allocation_pa FROM expense_allocation WHERE effective_date <= '".$effective_date."' ORDER BY effective_date DESC";

    	$result = run_query( $query, $cxn );

    	if (query_num_rows( $result ) == 0)
            $expense_allocation_pa = 0;
        else
        {
		    $data = get_row( $result );

    		$expense_allocation_pa = $data['expense_allocation_pa'];
        }
    
        return ($expense_allocation_pa);
    }


            // $effective_date as yyyy-mm-dd
    
    function get_hourly_rate( $employee_name, $effective_date, $cxn )
    {
        $day_of_week = jddayofweek( gregoriantojd( substr( $effective_date, 5, 2 ), substr( $effective_date, 8, 2 ), substr( $effective_date, 0, 4 ) ));

        
        $query = "SELECT * FROM salary_rate WHERE employee_name = '".$employee_name."' AND effective_date <= '".$effective_date."' ORDER BY effective_date DESC";

        $result = run_query( $query, $cxn );

        $data = get_row( $result );

        $rate = 0;
        
        
        if ($data['employment_basis'] == "Casual")    
        {
            if ($day_of_week == 0)
        		$rate = $data['sunday_rate'];
            else
            if ($day_of_week == 1)
        		$rate = $data['monday_rate'];
            else
            if ($day_of_week == 2)
        		$rate = $data['tuesday_rate'];
            else
            if ($day_of_week == 3)
        		$rate = $data['wednesday_rate'];
            else
            if ($day_of_week == 4)
        		$rate = $data['thursday_rate'];
            else
            if ($day_of_week == 5)
        		$rate = $data['friday_rate'];
            else
            if ($day_of_week == 6)
        		$rate = $data['saturday_rate'];
        }
        
        if ($data['employment_basis'] == "Full Time Perm" || $data['employment_basis'] == "Part Time Perm")
            $rate = $data['effective_hourly_rate'];


        return ($rate);
    }
    
    
    

		// don't put in the common library because different sites have different color schemes
		
	function form_start( $handler, $param1="", $value1="", $param2="", $value2="", $param3="", $value3="", $param4="", $value4="" )
	{
			//lightskyblue  #cceeff azure
			// lighter color first
			 //linear-gradient(#fcfcfc, #e1e1e1)
			 // linear-gradient(#fcfcfc, #e1e1e1)
			 
		echo "<form id='form' name='form' action='".url_encode( $handler, $param1, $value1, $param2, $value2, $param3, $value3, $param4, $value4 )."' method='POST'><table style='border: 1px solid #bbbbbb; background: #F8FbFF; border-radius: 10px'>\n";
		
//		echo "<form id='form' name='form' action='".url_encode( $handler, $param1, $value1, $param2, $value2, $param3, $value3 )."' method='POST'><table style='border: 1px solid #bbbbbb; background: linear-gradient(mintcream, teal)'>\n";
	}
	
	
    function generate_custom_fields( $newrecord, $form_name, $field_name, $right_side_pane, $screen_data, $screen_data_error, $cxn )
    {
        if ($form_name == "task" || $form_name == "mpl_quote")
        {
            write_update_function();
            
            $number_of_strategies_list = "<option></option><option>1</option><option>2</option><option>3</option><option>4</option><option>5</option><option>6</option><option>7</option><option>8</option><option>9</option><option>10</option><option>11</option><option>12</option>";
        
            $number_of_strategies = $screen_data['number_of_strategies'];
            
        	if ($number_of_strategies != "")
        	{
        		$pos = strpos( $number_of_strategies_list, "<option>".$number_of_strategies."</option>" );
        
        		if ($pos !== false)
        		{
        			$pos = $pos + 8;
        			$number_of_strategies_list = substr( $number_of_strategies_list, 0, $pos - 1 )." selected".substr( $number_of_strategies_list, $pos - 1, strlen( $number_of_strategies_list ) - $pos + 1 );
        		}
        	}
        
        	echo "<tr><td><span class='fprompt'>Number of strategies</span></td><td></td>";
        	
            if ($form_name == "task")
            	echo "<td><select id='number_of_strategies' name='number_of_strategies' class='finput' onchange='UpdateFee();'>".$number_of_strategies_list."</select></td></tr>";

            if ($form_name == "mpl_quote")
            	echo "<td><select id='number_of_strategies' name='number_of_strategies' class='finput' onchange='UpdateFee2();'>".$number_of_strategies_list."</select></td></tr>";
            	
        }    
    }

	
    function write_update_function()
    {
        echo "<script>";
        
        echo "function UpdateFee()";
        
        echo "{";

        echo "  var NumberofStrategies = document.getElementById( 'number_of_strategies' );";

        echo "  var soa_fee = document.getElementById( 'quoted_price' );";

        echo "  var paraplanner_commission = document.getElementById( 'paraplanner_commission' );";

        echo "  soa_fee.value = ".fee_calc_formula;

        echo "  paraplanner_commission.value = ".commission_calc_formula;

        echo "  checker_commission.value = ".checker_commission_calc_formula;
        echo "}";
        

        echo "function UpdateFee2()";
        
        echo "{";

        echo "  var NumberofStrategies = document.getElementById( 'number_of_strategies' );";

        echo "  var amount = document.getElementById( 'amount' );";

        echo "  amount_ex_gst.value = ".fee_calc_formula;
        
          echo "   gst.value =  parseInt(amount_ex_gst.value) * 0.1; ";
        
        echo "   if (gst.value.substr(gst.value.length-2, 1 ) == '.') ";
        echo "      gst.value = gst.value + '0'; ";

        echo "   total.value =  parseFloat(amount_ex_gst.value) + parseFloat(gst.value); ";

        echo "   if (total.value.substr(total.value.length-2, 1 ) == '.') ";
        echo "      total.value = total.value + '0'; ";
        
        echo "}";

        echo "</script>";
    }        
	
?>