<?php

	include "library.php";

	$cxn = start_code();

    exit_if_search_bot();

    exit_if_session_expired( $cxn );


    $pay_run_id = val( $_POST, "pay_run_id" );
    
    

	page_header( "Generate pay run", $cxn );

	$date_today = date( "Y-m-d H:i:s" );


    $query = "SELECT * FROM pay_run WHERE id = ".$pay_run_id;
    
    $result = run_query( $query, $cxn );
    
	$data = get_row( $result );

    if ($data['locked'] == "on")
        echo red( "<br><br>Pay run is locked.<br><br>" );
    else
    {
    	$pay_run_date = $data['run_date'];
    	
    
        $report_start_date = $data['start_of_period'];
    
        $report_end_date = $data['end_of_period'];
    
        
        $this_date_dt = date_create( $report_start_date );
    
        $this_date_str = $this_date_dt->format( "Y-m-d" );
    
    
        $day_of_week = jddayofweek( gregoriantojd( $this_date_dt->format( "m" ), $this_date_dt->format( "d" ), $this_date_dt->format( "Y" ) ));
    
    
        while ($this_date_str <= $report_end_date)
        {
            $query = "SELECT * FROM employee ORDER BY display_name";
            
            $result = run_query( $query, $cxn );
    
    
        	for ($i=0; $i < query_num_rows( $result ); $i++)
    	    {
        	    $data = get_row( $result );
            
                $employee_name = $data['display_name'];
                
    
    	        if (! isset( $salary_due[$employee_name] ))
    	            $salary_due[$employee_name] = 0;
    	            
    	        if (! isset( $taxable_salary[$employee_name] ))
    	            $taxable_salary[$employee_name] = 0;
    	            
    	        if (! isset( $superannuation_due[$employee_name] ))
    	             $superannuation_due[$employee_name] = 0;
    	            
    	        if (! isset( $annual_leave_accumulated_this_period[$employee_name] ))
    	            $annual_leave_accumulated_this_period[$employee_name] = 0;
    
    	        if (! isset( $personal_leave_accumulated_this_period[$employee_name] ))
    	            $personal_leave_accumulated_this_period[$employee_name] = 0;
    	            
    	        if (! isset( $total_hours_worked[$employee_name] ))
    	            $total_hours_worked[$employee_name] = 0;      
    	            
    	            
                $query2 = "SELECT * FROM hours_worked WHERE employee_name = '".$employee_name."' AND effective_date = '".$this_date_str."'";
            
                $result2 = run_query( $query2, $cxn );
        
        
             	for ($j=0; $j < query_num_rows( $result2 ); $j++)
                {
    	            $data2 = get_row( $result2 );
    
                    $hours_worked = $data2['hours_worked'];
        
                    if ($hours_worked == "")
                        $hours_worked = 0;
    
                    $query3 = "SELECT * FROM salary_rate WHERE employee_name = '".$employee_name."' AND effective_date <= '".$this_date_str."' ORDER BY effective_date DESC";
                
                    $result3 = run_query( $query3, $cxn );
            
        	        $data3 = get_row( $result3 );
        	        
        	        $frequency[$employee_name] = $data3['frequency'];
        	        
        
        	        if ($hours_worked > 0)
        	        {
        	            $rate = get_hourly_rate( $employee_name, $this_date_str, $cxn );
        
            	        $salary_due[$employee_name] += round( $hours_worked * $rate, 2 );
    
            	        if ($data2['lump_sum_tax_category'] == "" || $data2['lump_sum_tax_category'] == "UNUSED ANNUAL LEAVE")
                            $taxable_salary[$employee_name] += round( $hours_worked * $rate, 2 );
                        
                        
                        if ($data2['superannuation_on_this'] == "on")
                            $superannuation_due[$employee_name] += round( $hours_worked * $rate * 0.095, 2 );
                            
                            
        	            if ($data2['accumulate_leave_on_these_hours'] == 'on' && ($data3['employment_basis'] == "Full Time Perm" || $data3['employment_basis'] == "Part Time Perm"))
                        {    	        
                            $annual_leave_accumulated_this_period[$employee_name] += $hours_worked * ((4*38) / (38*52));
        
                            $personal_leave_accumulated_this_period[$employee_name] += $hours_worked * ((2*38) / (38*52));
                        }
                        
                        $total_hours_worked[$employee_name] += $hours_worked;
        	        }
                }
    	    }
    	        
    
        	date_add( $this_date_dt, date_interval_create_from_date_string( "1 day" ));
        	
            $this_date_str = $this_date_dt->format( "Y-m-d" );
            
            $day_of_week++;
            
            if ($day_of_week >= 7)
                $day_of_week = 0;
        }
    
    
        $query = "DELETE FROM pay_run_line WHERE pay_run_id = ".$pay_run_id;
        
        $result = run_query( $query, $cxn );
    
    
        $query = "SELECT * FROM employee ORDER BY display_name";
        
        $result = run_query( $query, $cxn );
    
    	for ($i=0; $i < query_num_rows( $result ); $i++)
        {
    	    $data = get_row( $result );
    
            $employee_start_date = $data['start_date'];
        
            $employee_name = $data['display_name'];
            
        
            if ($employee_start_date <= $report_end_date)
            {
                $this_salary_due = round( $salary_due[$data['display_name']], 2 );
                
                $hours_worked = $total_hours_worked[$data['display_name']];
        
                if ($this_salary_due > 0 || $hours_worked > 0)
                {
                    $annual_leave_accumulated = round( $annual_leave_accumulated_this_period[$data['display_name']], 2);
            
                    $personal_leave_accumulated = round( $personal_leave_accumulated_this_period[$data['display_name']], 2);
            
        
                         
                        // doesn't handle the case where there is a change in pay cycle frequency mid-way through a single pay period
                        
                    if ($frequency[$employee_name] == "Weekly")
                        $tax = round( (calc_tax( $this_salary_due * 52 ) / 52) - 0.5, 0 );
                    else
                    if ($frequency[$employee_name] == "Fortnightly")
                        $tax = round( (calc_tax( $this_salary_due * 26 ) / 26) - 0.5, 0 );

                    if ($tax < 0)
                        $tax = 0;
                        
                        
                    $super = round( $superannuation_due[$employee_name], 2 );
                   
                    $net_pay = round( $this_salary_due - $tax, 2 );
        
                    
                    if ($hours_worked > 0)
                    {
                        $query4 = "INSERT INTO pay_run_line ( pay_run_id, pay_run_date, employee_name, hours_worked, salary_due, tax, net_pay, superannuation, annual_leave_accumulated_this_period, personal_leave_accumulated_this_period, date_created ) VALUES (".$pay_run_id.", '".$pay_run_date."', '".$data['display_name']."', ".$hours_worked.", ".$this_salary_due.", ".$tax.", ".$net_pay.", ".$super.", ".$annual_leave_accumulated.", ".$personal_leave_accumulated.", '".$date_today."' )";
                    
                        $result4 = run_query( $query4, $cxn );
                    }
                }
            }
        }
    }
        
    
    echo "<br><br><br>";
  
  	echo "Finished<br><br>";
	  
    echo "<a href='/' class='glink'>Home</a><br>";
    
    echo "<br><br><br>";

    
            /* tax rates for 2018/19, doesn't fully take into account the medicare discount for low incomes */
        
    function calc_tax( $income )
    {
        if ($income > 180000)
            $tax2 = 54097 + (($income - 180000) * 0.45);
        else
        if ($income > 90000)
            $tax2 = 20797 + (($income - 90000) * 0.37);
        else
        if ($income > 37000)
            $tax2 = 3572 + (($income - 37000) * 0.325);
        else
        if ($income > 18200)
            $tax2 = (($income - 18200) * 0.19);
        else
            $tax2 = 0;
        
        
            // Medicare levy
            
        if ($income > 27475)
            $tax2 += $income * 0.02;
        else
        if ($income > 21980 && $income < 27475)
            $tax2 += ($income - 21980) * 0.1;


             // LITO
  
        if ($income <= 37000)
            $tax2 = $tax2 - 445;
        else
        if ($income < 66667)
            $tax2 = $tax2 - (445 - ($income - 37000) * 0.015);
        
        
          // LMITO, 2018/19 - 2021/22
        
        if ($income <= 37000)
            $tax2 = $tax2 - 200;
        else
        if ($income > 37000 && $income <= 48000)
            $tax2 = $tax2 - 200 - (($income - 37000) * 0.03);
        else
        if ($income > 37000 && $income <= 48000)
            $tax2 = $tax2 - 200 - (($income - 37000) * 0.03);
        else
        if ($income > 48000 && $income <= 90000)
            $tax2 = $tax2 - 530;
        else
        if ($income > 90000 && $income <= 125333)
            $tax2 = $tax2 - (530 - (($income - 90000) * 0.015));
        
        
        if ($tax2 < 0)
            $tax2 = 0;
      
        return ($tax2);
    }



        /* rates for 2018/19 */

    function fee_help_repayment( $income )
    {
        if ($income >= 51957 && $income <= 57729)
            $fee_help_repayment2 = $income * 0.02;
        else
        if ($income >= 57730 && $income <= 64306)
            $fee_help_repayment2 = $income * 0.04;
        else
        if ($income >= 64307 && $income <= 70881)
            $fee_help_repayment2 = $income * 0.045;
        else
        if ($income >= 70882 && $income <= 74607)
            $fee_help_repayment2 = $income * 0.05;
        else
        if ($income >= 74608 && $income <= 80197)
            $fee_help_repayment2 = $income * 0.055;
        else
        if ($income >= 80198 && $income <= 86855)
            $fee_help_repayment2 = $income * 0.06;
        else
        if ($income >= 86865 && $income <= 91425)
            $fee_help_repayment2 = $income * 0.065;
        else
        if ($income >= 91426 && $income <= 100613)
            $fee_help_repayment2 = $income * 0.07;
        else
        if ($income >= 100614 && $income <= 107213)
            $fee_help_repayment2 = $income * 0.075;
        else
        if ($income >= 107214)
            $fee_help_repayment2 = $income * 0.08;
        else
            $fee_help_repayment2 = 0;
            
        return ($fee_help_repayment2);
    }    


?>